/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util.filter;

import info.cho.passwords.fairy.util.exceptionally.SneakyThrowUtil;
import info.cho.passwords.fairy.util.exceptionally.ThrowingConsumer;
import info.cho.passwords.fairy.util.filter.FilterUnitImpl;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FilterUnit<T> {
    public static <T> FilterUnit<T> create() {
        return new FilterUnitImpl();
    }

    public static <T, E extends Exception> Predicate<T> test(@NotNull ThrowingConsumer<T, E> consumer, @NotNull Class<E> exceptionClass) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception e) {
                if (exceptionClass.isInstance(e)) {
                    return false;
                }
                SneakyThrowUtil.sneakyThrow(e);
            }
            return true;
        };
    }

    @Contract(value="_ -> this")
    public FilterUnit<T> predicate(@NotNull Predicate<T> var1);

    @Contract(value="_ -> this")
    public FilterUnit<T> addAll(@NotNull Iterable<T> var1);

    @Contract(value="_ -> this")
    public FilterUnit<T> add(@Nullable T var1);

    @Contract(value="_, _ -> this")
    public FilterUnit<T> add(@Nullable T var1, @NotNull Predicate<T> var2);

    @Contract(value="_ -> this")
    public FilterUnit<T> add(@NotNull Item<T> var1);

    @NotNull
    public Optional<T> find();

    @NotNull
    public Stream<T> findAll();

    public static interface Item<T> {
        public static <T> Item<T> create(@Nullable T value) {
            return new FilterUnitImpl.ItemImpl<T>(value);
        }

        public boolean match();

        @Nullable
        public T get();

        @NotNull
        public Iterable<Predicate<T>> predicates();

        @Contract(value="_ -> this")
        public Item<T> predicate(@NotNull Predicate<T> var1);
    }
}

