/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util.filter;

import info.cho.passwords.fairy.util.filter.FilterUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterUnitImpl<T>
implements FilterUnit<T> {
    private final List<Predicate<T>> predicates = new ArrayList<Predicate<T>>();
    private final List<FilterUnit.Item<T>> items = new ArrayList<FilterUnit.Item<T>>();

    @Override
    public FilterUnit<T> predicate(@NotNull Predicate<T> predicate) {
        this.predicates.add(predicate);
        return this;
    }

    @Override
    public FilterUnit<T> addAll(@NotNull Iterable<T> iterable) {
        iterable.forEach(this::add);
        return this;
    }

    @Override
    public FilterUnit<T> add(@Nullable T t) {
        FilterUnit.Item<T> item = FilterUnit.Item.create(t);
        this.items.add(item);
        return this;
    }

    @Override
    public FilterUnit<T> add(@Nullable T t, @NotNull Predicate<T> predicate) {
        FilterUnit.Item<T> item = FilterUnit.Item.create(t).predicate(predicate);
        this.items.add(item);
        return this;
    }

    @Override
    public FilterUnit<T> add(@NotNull FilterUnit.Item<T> item) {
        this.items.add(item);
        return this;
    }

    @Override
    @NotNull
    public Optional<T> find() {
        return this.findAll().findFirst();
    }

    @Override
    @NotNull
    public Stream<T> findAll() {
        return this.items.stream().filter(FilterUnit.Item::match).map(FilterUnit.Item::get).filter(item -> this.predicates.stream().allMatch(predicate -> predicate.test(item)));
    }

    public static class ItemImpl<T>
    implements FilterUnit.Item<T> {
        private final T value;
        private List<Predicate<T>> predicates = Collections.emptyList();

        @Override
        public boolean match() {
            return this.predicates.stream().allMatch(predicate -> predicate.test(this.value));
        }

        @Override
        @Nullable
        public T get() {
            return this.value;
        }

        @Override
        @NotNull
        public Iterable<Predicate<T>> predicates() {
            return this.predicates;
        }

        @Override
        public FilterUnit.Item<T> predicate(@NotNull Predicate<T> predicate) {
            if (this.predicates == Collections.EMPTY_LIST) {
                this.predicates = new ArrayList<Predicate<T>>();
            }
            this.predicates.add(predicate);
            return this;
        }

        public ItemImpl(T value) {
            this.value = value;
        }
    }
}

