/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util.terminable;

import info.cho.passwords.fairy.util.terminable.TerminableConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface Terminable {
    public static final Terminable EMPTY = () -> {};

    public void close() throws Exception;

    default public boolean isClosed() {
        return false;
    }

    @Nullable
    default public Exception closeSilently() {
        try {
            this.close();
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    default public void closeAndReportException() {
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    default public void bindWith(@NotNull TerminableConsumer consumer) {
        consumer.bind(this);
    }
}

