/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util.terminable.composite;

import info.cho.passwords.fairy.util.terminable.Terminable;
import info.cho.passwords.fairy.util.terminable.TerminableConsumer;
import info.cho.passwords.fairy.util.terminable.composite.AbstractCompositeTerminable;
import info.cho.passwords.fairy.util.terminable.composite.AbstractWeakCompositeTerminable;
import info.cho.passwords.fairy.util.terminable.composite.CompositeClosingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CompositeTerminable
extends Terminable,
TerminableConsumer {
    @NotNull
    public static CompositeTerminable create() {
        return new AbstractCompositeTerminable();
    }

    @NotNull
    public static CompositeTerminable createWeak() {
        return new AbstractWeakCompositeTerminable();
    }

    @Override
    public void close() throws CompositeClosingException;

    @Override
    @Nullable
    default public CompositeClosingException closeSilently() {
        try {
            this.close();
            return null;
        }
        catch (CompositeClosingException e) {
            return e;
        }
    }

    @Override
    default public void closeAndReportException() {
        try {
            this.close();
        }
        catch (CompositeClosingException e) {
            e.printAllStackTraces();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CompositeTerminable with(Terminable var1);

    default public CompositeTerminable withAll(Terminable ... terminables) {
        for (Terminable terminable : terminables) {
            if (terminable == null) continue;
            this.bind(terminable);
        }
        return this;
    }

    default public CompositeTerminable withAll(Iterable<? extends Terminable> terminables) {
        for (Terminable terminable : terminables) {
            if (terminable == null) continue;
            this.bind(terminable);
        }
        return this;
    }

    @Override
    @NotNull
    default public <T extends Terminable> T bind(@NotNull T terminable) {
        this.with(terminable);
        return terminable;
    }

    public void cleanup();
}

