/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.server;

import info.cho.passwords.Passwords;
import info.cho.passwords.config.Config;
import info.cho.passwords.fairy.bukkit.listener.RegisterAsListener;
import info.cho.passwords.fairy.container.InjectableComponent;
import info.cho.passwords.fairy.log.Log;
import info.cho.passwords.util.DataManager;
import info.cho.passwords.util.Messages;
import java.net.InetAddress;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@InjectableComponent
@RegisterAsListener
public class ServerPasswordsListener
implements Listener {
    private final Passwords passwords = Passwords.instance;
    private final DataManager dataManager = Passwords.dataManager;
    private final Config config = Passwords.config;
    public boolean isIpLogin = false;

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (this.config.getCheckType().equals("server")) {
            Player player = event.getPlayer();
            this.dataManager.setPlayerValue(player, "charSlot", 0);
            InetAddress address = event.getPlayer().getAddress().getAddress();
            String ipAddress = address.getHostAddress();
            if (this.config.isLoginIp()) {
                if (!ipAddress.equals(this.dataManager.getPlayerValue(player, "playerIp"))) {
                    this.dataManager.setPlayerValue(player, "playerIp", ipAddress);
                    this.dataManager.setPlayerValue(player, "password", null);
                    int passwordLength = this.config.getPasswordLength();
                    for (int i = 0; i < passwordLength; ++i) {
                        this.dataManager.setPlayerValue(player, "char" + i, null);
                    }
                    this.openPasswordUI(player);
                    this.isIpLogin = false;
                } else if (ipAddress.equals(this.dataManager.getPlayerValue(player, "playerIp"))) {
                    this.dataManager.setPlayerValue(player, "isLogIn", true);
                    this.displayWelcomeMessage(player);
                    this.setGameMode(player);
                    player.closeInventory();
                    this.isIpLogin = true;
                }
            } else {
                this.isIpLogin = false;
                int passwordLength = this.config.getPasswordLength();
                for (int i = 0; i < passwordLength; ++i) {
                    this.dataManager.setPlayerValue(player, "char" + i, null);
                }
                this.dataManager.setPlayerValue(player, "password", null);
                this.openPasswordUI(player);
            }
        }
    }

    public void openPasswordUI(Player player) {
        Inventory passwordInventory = this.passwords.getInventory();
        this.initializeCraftingItems(passwordInventory);
        player.openInventory(passwordInventory);
    }

    public void initializeCraftingItems(Inventory inventory) {
        ItemStack selectItem = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        for (int i = 0; i < 9; ++i) {
            ItemMeta itemMeta = selectItem.getItemMeta();
            if (itemMeta == null) continue;
            itemMeta.setDisplayName("\u00a72" + (i + 1));
            itemMeta.setCustomModelData(Integer.valueOf(2700 + i));
            selectItem.setItemMeta(itemMeta);
            inventory.setItem(i, selectItem);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.config.getCheckType().equals("server")) {
            Player player = (Player)event.getWhoClicked();
            if (event.getView().getTitle().equals(this.config.getGuiName())) {
                event.setCancelled(true);
                int passwordLength = this.config.getPasswordLength();
                String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
                int charSlot = (Integer)this.dataManager.getPlayerValue(player, "charSlot");
                if (charSlot < passwordLength) {
                    for (int i = 1; i <= 9; ++i) {
                        if (!displayName.equals("\u00a72" + i)) continue;
                        this.dataManager.setPlayerValue(player, "char" + charSlot, i);
                        this.dataManager.setPlayerValue(player, "charSlot", charSlot + 1);
                        break;
                    }
                }
                this.updateSlotAppearance(event, displayName);
                if (charSlot == passwordLength - 1) {
                    this.handlePasswordEntry(player, passwordLength);
                }
            }
        }
    }

    private void updateSlotAppearance(InventoryClickEvent event, String displayName) {
        int fixSlot = event.getSlot();
        int modelData = event.getCurrentItem().getItemMeta().getCustomModelData();
        ItemStack greenSlot = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta greenSlotMeta = greenSlot.getItemMeta();
        if (greenSlotMeta != null) {
            greenSlotMeta.setDisplayName(displayName);
            greenSlotMeta.setCustomModelData(Integer.valueOf(modelData + 100));
            greenSlot.setItemMeta(greenSlotMeta);
        }
        event.getInventory().setItem(fixSlot, greenSlot);
    }

    private void handlePasswordEntry(Player player, int passwordLength) {
        Object password = "";
        if (!this.isIpLogin) {
            for (int i = 0; i < passwordLength; ++i) {
                password = (String)password + String.valueOf(this.dataManager.getPlayerValue(player, "char" + i));
            }
            this.dataManager.setPlayerValue(player, "password", password);
        } else {
            password = (String)this.dataManager.getPlayerValue(player, "password");
        }
        if (((String)password).equals(this.config.getServerPassword())) {
            this.dataManager.setPlayerValue(player, "isLogIn", true);
            player.closeInventory();
            this.displayWelcomeMessage(player);
            this.setGameMode(player);
            this.setLoginIp(player);
        } else if (((String)password).equals(this.config.getAdminPassword()) && this.config.isAdminPasswordEnabled()) {
            this.dataManager.setPlayerValue(player, "isLogIn", true);
            player.closeInventory();
            player.setOp(this.config.isAdminOp());
        } else {
            player.kickPlayer(this.config.getFailMessage());
            this.dataManager.setPlayerValue(player, "playerIp", "NULL");
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player;
        Boolean isLogIn;
        if (this.config.getCheckType().equals("server") && event.getView().getTitle().equals(this.config.getGuiName()) && !(isLogIn = (Boolean)this.dataManager.getPlayerValue(player = (Player)event.getPlayer(), "isLogIn")).booleanValue()) {
            player.kickPlayer(this.config.getCloseUiMessage());
        }
    }

    @EventHandler
    public void onMovementCheck(PlayerMoveEvent event) {
        Boolean isLogIn;
        Boolean preventMovement;
        if (this.config.getCheckType().equals("server") && (preventMovement = Boolean.valueOf(this.config.isPreventsMovement())).booleanValue() && !(isLogIn = (Boolean)this.dataManager.getPlayerValue(event.getPlayer(), "isLogIn")).booleanValue()) {
            event.setCancelled(true);
            event.getPlayer().kickPlayer(this.config.getMessageKickMovement());
        }
    }

    public void setLoginIp(Player player) {
        InetAddress address = player.getAddress().getAddress();
        String ipAddress = address.getHostAddress();
        this.dataManager.setPlayerValue(player, "playerIp", ipAddress);
    }

    private void displayWelcomeMessage(Player player) {
        if (this.config.isWelcomeMessageEnabled()) {
            Messages messages = new Messages();
            String messageType = this.config.getWelcomeMessageDisplayType();
            String message = this.config.getWelcomeMessage();
            String secondMessage = this.config.getWelcomeMessageSecond();
            switch (messageType) {
                case "chat": {
                    messages.sendMessage(player, message);
                    break;
                }
                case "actionbar": {
                    messages.sendActionBar(player, message);
                    break;
                }
                case "title": {
                    messages.sendTitle(player, message, secondMessage);
                    break;
                }
                default: {
                    Log.info(String.valueOf(ChatColor.RED) + "[Error] Invalid type for welcome message", new Object[0]);
                }
            }
        }
    }

    private void setGameMode(Player player) {
        if (this.config.isLoginGamemodeEnabled()) {
            String gamemodeString;
            switch (gamemodeString = this.config.getLoginGamemode()) {
                case "survival": {
                    player.setGameMode(GameMode.SURVIVAL);
                    break;
                }
                case "creative": {
                    player.setGameMode(GameMode.CREATIVE);
                    break;
                }
                case "spectator": {
                    player.setGameMode(GameMode.SPECTATOR);
                    break;
                }
                case "adventure": {
                    player.setGameMode(GameMode.ADVENTURE);
                    break;
                }
                default: {
                    Log.info(String.valueOf(ChatColor.RED) + "[Error] Invalid gamemode", new Object[0]);
                }
            }
        }
    }
}

