/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class DataManager {
    private final File playerDataFolder;
    private final Map<UUID, FileConfiguration> configCache = new HashMap<UUID, FileConfiguration>();
    private FileConfiguration publicVarsConfig;

    public DataManager(File pluginFolder) {
        this.playerDataFolder = new File(pluginFolder, "data");
        File playerDataFolderOld = new File(pluginFolder, "playerdata");
        if (!this.playerDataFolder.exists()) {
            this.playerDataFolder.mkdirs();
            if (playerDataFolderOld.isDirectory()) {
                for (File file : Objects.requireNonNull(playerDataFolderOld.listFiles())) {
                    File newFileLocation = new File(this.playerDataFolder, file.getName());
                    if (file.renameTo(newFileLocation)) continue;
                    System.err.println("File " + file.getName() + " could not be moved to the new location.");
                }
            }
        }
    }

    private FileConfiguration getPlayerConfig(UUID playerUUID) {
        File playerFile = new File(this.playerDataFolder, playerUUID.toString() + ".yml");
        FileConfiguration config = this.configCache.get(playerUUID);
        if (config == null || !playerFile.exists()) {
            if (!playerFile.exists()) {
                try {
                    playerFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            config = YamlConfiguration.loadConfiguration((File)playerFile);
            this.configCache.put(playerUUID, config);
        }
        return config;
    }

    public void savePlayerConfig(UUID playerUUID, FileConfiguration config) {
        File playerFile = new File(this.playerDataFolder, playerUUID.toString() + ".yml");
        try {
            config.save(playerFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setPlayerValue(Player player, String path, Object value) {
        FileConfiguration config = this.getPlayerConfig(player.getUniqueId());
        config.set(path, value);
        this.savePlayerConfig(player.getUniqueId(), config);
    }

    public Object getPlayerValue(Player player, String path) {
        FileConfiguration config = this.getPlayerConfig(player.getUniqueId());
        return config.get(path);
    }

    public void addValue(Player player, String variableName, Object defaultValue) {
        FileConfiguration config = this.getPlayerConfig(player.getUniqueId());
        if (!config.contains(variableName)) {
            config.set(variableName, defaultValue);
            this.savePlayerConfig(player.getUniqueId(), config);
        }
    }

    public boolean contains(Player player, String path) {
        FileConfiguration config = this.getPlayerConfig(player.getUniqueId());
        return config.contains(path);
    }

    public List<UUID> getAllPlayerUUIDs() {
        File[] files;
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        if (this.playerDataFolder.exists() && this.playerDataFolder.isDirectory() && (files = this.playerDataFolder.listFiles((dir, name) -> name.endsWith(".yml"))) != null) {
            for (File file : files) {
                String fileName = file.getName();
                try {
                    UUID uuid = UUID.fromString(fileName.replace(".yml", ""));
                    uuids.add(uuid);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Invalid UUID in file name: " + fileName);
                }
            }
        }
        return uuids;
    }
}

