/*
 * Decompiled with CFR 0.152.
 */
package info.cho.libs.commandapi.arguments;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import info.cho.libs.commandapi.CommandAPIBukkit;
import info.cho.libs.commandapi.CommandAPIPaper;
import info.cho.libs.commandapi.arguments.CommandAPIArgumentType;
import info.cho.libs.commandapi.arguments.SafeOverrideableArgument;
import info.cho.libs.commandapi.executors.CommandArguments;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncPlayerProfileArgument
extends SafeOverrideableArgument<CompletableFuture<List<PlayerProfile>>, PlayerProfile> {
    public AsyncPlayerProfileArgument(String nodeName) {
        super(nodeName, CommandAPIBukkit.get().getNMS()._ArgumentProfile(), PlayerProfile::getName);
    }

    @Override
    public Class<CompletableFuture<List<PlayerProfile>>> getPrimitiveType() {
        return CompletableFuture.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.ASYNC_OFFLINE_PLAYER;
    }

    @Override
    public <CommandSourceStack> CompletableFuture<List<PlayerProfile>> parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return CommandAPIPaper.getPaper().getNMS().getProfile(cmdCtx, key);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

