/*
 * Decompiled with CFR 0.152.
 */
package info.cho.libs.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import info.cho.libs.commandapi.CommandAPIBukkit;
import info.cho.libs.commandapi.arguments.CommandAPIArgumentType;
import info.cho.libs.commandapi.arguments.CustomProvidedArgument;
import info.cho.libs.commandapi.arguments.SafeOverrideableArgument;
import info.cho.libs.commandapi.arguments.SuggestionProviders;
import info.cho.libs.commandapi.executors.CommandArguments;
import java.util.function.Function;
import org.bukkit.block.Biome;

public class BiomeArgument
extends SafeOverrideableArgument<Biome, Biome>
implements CustomProvidedArgument {
    public BiomeArgument(String nodeName) {
        super(nodeName, CommandAPIBukkit.get().getNMS()._ArgumentSyntheticBiome(), ((Function<Biome, String>)biome -> biome.name()).andThen(String::toLowerCase));
    }

    @Override
    public Class<Biome> getPrimitiveType() {
        return Biome.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.BIOME;
    }

    @Override
    public SuggestionProviders getSuggestionProvider() {
        return SuggestionProviders.BIOMES;
    }

    @Override
    public <CommandSourceStack> Biome parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return CommandAPIBukkit.get().getNMS().getBiome(cmdCtx, key).type().get();
    }

    public static class NamespacedKey
    extends SafeOverrideableArgument<org.bukkit.NamespacedKey, org.bukkit.NamespacedKey>
    implements CustomProvidedArgument {
        public NamespacedKey(String nodeName) {
            super(nodeName, CommandAPIBukkit.get().getNMS()._ArgumentSyntheticBiome(), org.bukkit.NamespacedKey::toString);
        }

        @Override
        public SuggestionProviders getSuggestionProvider() {
            return SuggestionProviders.BIOMES;
        }

        @Override
        public Class<org.bukkit.NamespacedKey> getPrimitiveType() {
            return org.bukkit.NamespacedKey.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return CommandAPIArgumentType.BIOME;
        }

        @Override
        public <CommandSourceStack> org.bukkit.NamespacedKey parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
            return CommandAPIBukkit.get().getNMS().getBiome(cmdCtx, key).key().get();
        }
    }
}

