/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords;

import info.cho.libs.commandapi.CommandAPI;
import info.cho.libs.commandapi.CommandAPIPaperConfig;
import info.cho.passwords.commads.LogoutPlayerCommand;
import info.cho.passwords.commads.SetPasswordCommand;
import info.cho.passwords.commads.SetPlayerPasswordCommand;
import info.cho.passwords.customGui.CustomGui;
import info.cho.passwords.customGui.CustomGuiHandler;
import info.cho.passwords.hook.DiscordHook;
import info.cho.passwords.player.PasswordPlayerMode;
import info.cho.passwords.server.PasswordNoneMode;
import info.cho.passwords.server.PasswordPatternMode;
import info.cho.passwords.server.PasswordServerMode;
import info.cho.passwords.utls.PLog;
import info.cho.passwords.utls.PlayerInventorySave;
import info.cho.passwordsApi.password.PasswordConfig;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import java.util.Objects;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Passwords
extends JavaPlugin {
    public static Passwords instance;
    public static CustomGui customGui;
    public static String version;

    public void onLoad() {
        instance = this;
        customGui = new CustomGui();
        this.saveDefaultConfig();
        CommandAPI.onLoad(new CommandAPIPaperConfig((LifecycleEventOwner)this).verboseOutput(PasswordConfig.isDebugMode()));
    }

    public void onEnable() {
        CommandAPI.onEnable();
        CustomGuiHandler customGuiHandler = new CustomGuiHandler(customGui);
        if (PasswordConfig.isUseDiscordLogin()) {
            DiscordHook discordHook = new DiscordHook();
        }
        if (!PasswordConfig.isEnabled()) {
            PLog.warning("Passwords plugin is disabled!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        PLog.info("Passwords plugin is enabled!");
        this.versionCheck();
        LogoutPlayerCommand logoutPlayerCommand = new LogoutPlayerCommand();
        SetPlayerPasswordCommand setPlayerPasswordCommand = new SetPlayerPasswordCommand();
        SetPasswordCommand setPasswordCommand = new SetPasswordCommand();
        customGui.registerGui("server", PasswordServerMode.class);
        customGui.registerGui("player", PasswordPlayerMode.class);
        customGui.registerGui("none", PasswordNoneMode.class);
        customGui.registerGui("pattern", PasswordPatternMode.class);
        if (PasswordConfig.useAutoSave()) {
            PlayerInventorySave.savePlayerInventory();
        }
    }

    public void onDisable() {
        CommandAPI.onDisable();
        PLog.debug("Disabling passwords plugin");
    }

    private void versionCheck() {
        if (!Objects.equals(version, this.getConfig().getString("version"))) {
            PLog.warning("!!!!!!!!-----------------------------------------------------------------------------------!!!!!!!!");
            PLog.warning("Your version is outdated! Please delete the config.yml and restart the server to get the latest version!");
            PLog.warning("DO NOT DELETE THE Data FOLDER OR ALL INVENTORIES WILL BE LOST!");
            PLog.warning("Your version: " + version);
            PLog.warning("Config version: " + PasswordConfig.getVersion());
            PLog.warning("!!!!!!!!-----------------------------------------------------------------------------------!!!!!!!!");
        } else {
            PLog.info("Your version is up to date!");
            PLog.debug("!!!!!!!!------------------------ This is not an Error -------------------------------------!!!!!!!!");
            PLog.debug("Your version: " + version);
            PLog.debug("Config version: " + PasswordConfig.getVersion());
            PLog.debug("!!!!!!!!-----------------------------------------------------------------------------------!!!!!!!!");
        }
    }

    static {
        version = "2.6.1";
    }
}

