/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.customGui;

import info.cho.passwords.Passwords;
import info.cho.passwords.customGui.CustomGui;
import info.cho.passwords.utls.DataManager;
import info.cho.passwords.utls.PLog;
import info.cho.passwordsApi.password.PasswordConfig;
import info.cho.passwordsApi.password.customgui.PasswordsGui;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class CustomGuiHandler
implements Listener {
    private final CustomGui customGui;

    public CustomGuiHandler(CustomGui customGui) {
        Passwords passwords = Passwords.instance;
        this.customGui = customGui;
        passwords.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)passwords);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onGuiOpen(PlayerJoinEvent event) {
        DataManager dataManager = new DataManager();
        dataManager.addValue(event.getPlayer(), "isLogin", false);
        dataManager.setPlayerValue(event.getPlayer(), "isLogin", false);
        dataManager.addValue(event.getPlayer(), "password", "n/a");
        PLog.debug("onGuiOpen");
        for (Map.Entry<String, Class<?>> entry : this.customGui.customGuiList.entrySet()) {
            if (!Objects.equals(PasswordConfig.getCheckType(), entry.getKey())) continue;
            try {
                if (event.getPlayer().isDead()) {
                    event.getPlayer().spigot().respawn();
                }
                PasswordsGui passwordGui = (PasswordsGui)entry.getValue().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                passwordGui.openGui(event);
                if (passwordGui.getInventory(event.getPlayer()) == null) {
                    PLog.debug("Password GUI is null, returning.");
                    return;
                }
                if (PasswordConfig.invulnerableOnLogin()) {
                    event.getPlayer().setInvulnerable(true);
                }
                event.getPlayer().openInventory(passwordGui.getInventory(event.getPlayer()));
                PLog.debug("onGuiOpen end");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onGuiInteract(InventoryClickEvent event) {
        PLog.debug("onGuiInteract");
        for (Map.Entry<String, Class<?>> entry : this.customGui.customGuiList.entrySet()) {
            if (!Objects.equals(PasswordConfig.getCheckType(), entry.getKey())) continue;
            try {
                if (event.getCurrentItem().getType() != Material.GRAY_STAINED_GLASS_PANE && event.getCurrentItem().getType() != Material.GREEN_STAINED_GLASS_PANE) {
                    return;
                }
                PLog.debug("onGuiInteract");
                DataManager dataManager = new DataManager();
                PLog.debug("Player login test");
                if (((Boolean)dataManager.getPlayerValue((Player)event.getWhoClicked(), "isLogin")).booleanValue()) {
                    PLog.debug("Player is already logged in");
                    continue;
                }
                PasswordsGui passwordGui = (PasswordsGui)entry.getValue().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                passwordGui.interactGui(event);
                event.setCancelled(true);
                PLog.debug("onGuiInteract end");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onGuiClose(InventoryCloseEvent event) {
        PLog.debug("onGuiClose");
        for (Map.Entry<String, Class<?>> entry : this.customGui.customGuiList.entrySet()) {
            if (!Objects.equals(PasswordConfig.getCheckType(), entry.getKey())) continue;
            try {
                PasswordsGui passwordGui = (PasswordsGui)entry.getValue().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                passwordGui.closeGui(event);
                if (PasswordConfig.invulnerableOnLogin()) {
                    event.getPlayer().setInvulnerable(false);
                }
                PLog.debug("onGuiClose end");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerQuit(PlayerQuitEvent event) {
        PLog.debug("playerQuit");
        for (Map.Entry<String, Class<?>> entry : this.customGui.customGuiList.entrySet()) {
            if (!Objects.equals(PasswordConfig.getCheckType(), entry.getKey())) continue;
            try {
                DataManager dataManager = new DataManager();
                if (Objects.equals(dataManager.getPlayerValue(event.getPlayer(), "isLogin").toString(), "false")) {
                    PLog.debug("Player is not logged in");
                    return;
                }
                PasswordsGui passwordGui = (PasswordsGui)entry.getValue().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                passwordGui.playerQuit(event);
                PLog.debug("playerQuit end");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

