/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.player;

import info.cho.passwords.utls.PLog;
import info.cho.passwordsApi.password.PasswordConfig;
import info.cho.passwordsApi.password.customgui.PasswordsGui;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PasswordPlayerMode
extends PasswordsGui {
    @Override
    public void openGui(PlayerJoinEvent event) {
        this.generateStdVariables(PasswordConfig.getPasswordLength(), event.getPlayer());
    }

    @Override
    public void interactGui(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        int passwordLength = PasswordConfig.getPlayerPasswordLength();
        PLog.debug("Password length: " + passwordLength);
        boolean hasPassword = !this.getDataManager().getPlayerValue(player, "password").equals("n/a");
        this.getDataManager().setPlayerValue(player, "char" + (Integer)this.getDataManager().getPlayerValue(player, "charLocation"), event.getSlot() + 1);
        this.getDataManager().setPlayerValue(player, "charLocation", (Integer)this.getDataManager().getPlayerValue(player, "charLocation") + 1);
        ItemStack item = event.getCurrentItem();
        ItemStack newItem = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta != null) {
            itemMeta.displayName((Component)Component.text((int)(event.getSlot() + 1), (TextColor)NamedTextColor.GREEN));
            newItem.setItemMeta(itemMeta);
        }
        event.getInventory().setItem(event.getSlot(), newItem);
        if ((Integer)this.getDataManager().getPlayerValue(player, "charLocation") > passwordLength) {
            Object password = "";
            for (int i = 1; i <= passwordLength; ++i) {
                password = (String)password + String.valueOf(this.getDataManager().getPlayerValue(player, "char" + i));
            }
            if (!hasPassword) {
                this.getDataManager().setPlayerValue(player, "password", password);
                this.getDataManager().setPlayerValue(player, "isLogin", true);
                player.closeInventory();
                this.welcomeMessage(player);
                this.gamemodeSwitch(player);
                PLog.debug("Player password set to: " + (String)password);
                return;
            }
            if (this.getDataManager().getPlayerValue(player, "password").equals(password)) {
                this.getDataManager().setPlayerValue(player, "isLogin", true);
                player.closeInventory();
                this.welcomeMessage(player);
                this.gamemodeSwitch(player);
                PLog.debug("Login gamemode enabled");
            } else {
                player.kick((Component)Component.text((String)PasswordConfig.getFailMessage(), (TextColor)NamedTextColor.RED));
            }
        }
        event.setCancelled(true);
    }

    @Override
    public void closeGui(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (((Boolean)this.getDataManager().getPlayerValue(player, "isLogin")).booleanValue()) {
            return;
        }
        player.kick((Component)Component.text((String)PasswordConfig.getCloseUiMessage(), (TextColor)NamedTextColor.RED));
    }

    @Override
    public Inventory getInventory(Player player) {
        Inventory inventory = this.getDataManager().getPlayerValue(player, "password").equals("n/a") ? Bukkit.createInventory(null, (InventoryType)InventoryType.DISPENSER, (Component)Component.text((String)PasswordConfig.getSetPasswordName())) : Bukkit.createInventory(null, (InventoryType)InventoryType.DROPPER, (Component)Component.text((String)PasswordConfig.getGuiName()));
        ItemStack selectItem = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        for (int i = 0; i < 9; ++i) {
            ItemMeta itemMeta = selectItem.getItemMeta();
            if (itemMeta == null) continue;
            itemMeta.displayName((Component)Component.text((int)(i + 1), (TextColor)NamedTextColor.GREEN));
            selectItem.setItemMeta(itemMeta);
            inventory.setItem(i, selectItem);
        }
        return inventory;
    }
}

