/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit;

import info.cho.passwords.fairy.Debug;
import info.cho.passwords.fairy.FairyPlatform;
import info.cho.passwords.fairy.PlatformType;
import info.cho.passwords.fairy.bukkit.events.PostServicesInitialEvent;
import info.cho.passwords.fairy.bukkit.listener.FilteredListener;
import info.cho.passwords.fairy.bukkit.listener.RegisterAsListener;
import info.cho.passwords.fairy.bukkit.listener.events.Events;
import info.cho.passwords.fairy.bukkit.logger.ConsoleSenderLogger;
import info.cho.passwords.fairy.bukkit.metadata.Metadata;
import info.cho.passwords.fairy.bukkit.plugin.BukkitPluginHandler;
import info.cho.passwords.fairy.bukkit.plugin.impl.RootJavaPluginIdentifier;
import info.cho.passwords.fairy.bukkit.util.JavaPluginUtil;
import info.cho.passwords.fairy.bukkit.util.SpigotUtil;
import info.cho.passwords.fairy.container.PreInitialize;
import info.cho.passwords.fairy.container.collection.ContainerObjCollector;
import info.cho.passwords.fairy.log.Log;
import info.cho.passwords.fairy.plugin.Plugin;
import info.cho.passwords.fairy.plugin.PluginManager;
import info.cho.passwords.fairy.util.URLClassLoaderAccess;
import info.cho.passwords.fairy.util.terminable.Terminable;
import info.cho.passwords.fairy.util.terminable.TerminableConsumer;
import info.cho.passwords.fairy.util.terminable.composite.CompositeTerminable;
import java.io.File;
import java.net.URLClassLoader;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class FairyBukkitPlatform
extends FairyPlatform
implements TerminableConsumer {
    public static JavaPlugin PLUGIN = JavaPluginUtil.getProvidingPlugin(FairyBukkitPlatform.class);
    private final URLClassLoaderAccess classLoader;
    private final File dataFolder;
    private final CompositeTerminable compositeTerminable;

    @Override
    @NotNull
    public <T extends Terminable> T bind(@NotNull T terminable) {
        return this.compositeTerminable.bind(terminable);
    }

    public FairyBukkitPlatform(File dataFolder) {
        FairyPlatform.INSTANCE = this;
        this.dataFolder = dataFolder;
        this.compositeTerminable = CompositeTerminable.create();
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.classLoader = classLoader instanceof URLClassLoader ? URLClassLoaderAccess.create((URLClassLoader)classLoader) : URLClassLoaderAccess.create(null);
        PluginManager.initialize(new BukkitPluginHandler());
        if (!Debug.UNIT_TEST) {
            Log.set(new ConsoleSenderLogger(Bukkit.getConsoleSender()));
        }
    }

    @Override
    public void load(Plugin plugin) {
        super.load(plugin);
    }

    @Override
    public void enable() {
        SpigotUtil.init();
        super.enable();
    }

    @Override
    public void disable() {
        super.disable();
        RootJavaPluginIdentifier.clearInstance();
        Metadata.destroy();
    }

    @PreInitialize
    public void onPreInitialize() {
        this.getContainerContext().objectCollectorRegistry().add(ContainerObjCollector.create().withFilter(ContainerObjCollector.inherits(Listener.class)).withFilter(ContainerObjCollector.inherits(FilteredListener.class).negate()).withAddHandler(ContainerObjCollector.warpInstance(Listener.class, listener -> {
            if (!listener.getClass().isAnnotationPresent(RegisterAsListener.class)) {
                return;
            }
            Events.subscribe(listener);
        })).withRemoveHandler(ContainerObjCollector.warpInstance(Listener.class, HandlerList::unregisterAll)));
    }

    @Override
    public void onPostServicesInitial() {
        Events.call(new PostServicesInitialEvent());
    }

    @Override
    public void saveResource(String name, boolean replace) {
        PLUGIN.saveResource(name, replace);
    }

    @Override
    public URLClassLoaderAccess getClassloader() {
        return this.classLoader;
    }

    @Override
    public File getDataFolder() {
        return this.dataFolder;
    }

    @Override
    public void shutdown() {
        Bukkit.shutdown();
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public PlatformType getPlatformType() {
        return PlatformType.BUKKIT;
    }
}

