/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.command.parameters;

import info.cho.passwords.fairy.bukkit.command.parameters.BukkitArgTransformer;
import info.cho.passwords.fairy.container.InjectableComponent;
import info.cho.passwords.fairy.container.PostInitialize;
import info.cho.passwords.fairy.mc.MCServer;
import info.cho.passwords.fairy.mc.version.MCVersion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@InjectableComponent
public class GameModeArgTransformer
extends BukkitArgTransformer<GameMode> {
    private final Map<String, GameMode> gamemodeMap = new HashMap<String, GameMode>();

    @PostInitialize
    public void onPostInitialize() {
        this.gamemodeMap.put("creative", GameMode.CREATIVE);
        this.gamemodeMap.put("1", GameMode.CREATIVE);
        this.gamemodeMap.put("survival", GameMode.SURVIVAL);
        this.gamemodeMap.put("0", GameMode.SURVIVAL);
        this.gamemodeMap.put("adventure", GameMode.ADVENTURE);
        this.gamemodeMap.put("2", GameMode.ADVENTURE);
        if (MCServer.current().getVersion().isHigherOrEqual(MCVersion.of(8))) {
            this.gamemodeMap.put("spectator", GameMode.SPECTATOR);
            this.gamemodeMap.put("3", GameMode.SPECTATOR);
        }
    }

    @Override
    public GameMode transform(CommandSender sender, String source) {
        if (!this.gamemodeMap.containsKey(source.toLowerCase())) {
            return (GameMode)this.fail(source + " is not a valid game mode.");
        }
        return this.gamemodeMap.get(source.toLowerCase());
    }

    @Override
    public List<String> tabComplete(Player sender, String source) {
        return this.gamemodeMap.keySet().stream().filter(string -> StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)source)).collect(Collectors.toList());
    }

    @Override
    public Class[] type() {
        return new Class[]{GameMode.class};
    }
}

