/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.command.util;

import info.cho.passwords.fairy.Debug;
import info.cho.passwords.fairy.libs.xseries.XMaterial;
import info.cho.passwords.fairy.util.AccessUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.Nullable;

public final class CommandUtil {
    private static Supplier<CommandMap> COMMAND_MAP_SUPPLIER;

    public static boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isShort(String input) {
        try {
            Short.parseShort(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static ItemStack get(String input) {
        XMaterial material = XMaterial.matchXMaterial(input).orElse(null);
        if (material == null) {
            return null;
        }
        return material.parseItem();
    }

    public static CommandMap getCommandMap() {
        if (Debug.UNIT_TEST) {
            return null;
        }
        if (COMMAND_MAP_SUPPLIER == null) {
            try {
                PluginManager pluginManager = Bukkit.getPluginManager();
                Field field = pluginManager.getClass().getDeclaredField("commandMap");
                AccessUtil.setAccessible(field);
                COMMAND_MAP_SUPPLIER = () -> {
                    try {
                        return (CommandMap)field.get(pluginManager);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                };
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return COMMAND_MAP_SUPPLIER.get();
    }

    @Nullable
    public static Map<String, Command> getKnownCommands(CommandMap commandMap) {
        Class mapClass = commandMap.getClass();
        try {
            Method getKnownCommands = mapClass.getDeclaredMethod("getKnownCommands", new Class[0]);
            AccessUtil.setAccessible(getKnownCommands);
            return (Map)getKnownCommands.invoke((Object)commandMap, new Object[0]);
        }
        catch (ReflectiveOperationException getKnownCommands) {
            try {
                Field knownMapField = mapClass.getDeclaredField("knownCommands");
                AccessUtil.setAccessible(knownMapField);
                return (Map)knownMapField.get(commandMap);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new IllegalStateException("Unable to get knownCommands field from " + mapClass);
            }
        }
    }

    public static void syncCommands() {
        Server server = Bukkit.getServer();
        try {
            Method syncCommands = server.getClass().getDeclaredMethod("syncCommands", new Class[0]);
            AccessUtil.setAccessible(syncCommands);
            syncCommands.invoke((Object)server, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private CommandUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

