/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.configuration;

import info.cho.passwords.fairy.bukkit.FairyBukkitPlatform;
import info.cho.passwords.fairy.bukkit.mc.BukkitMCServer;
import info.cho.passwords.fairy.bukkit.mc.entity.BukkitDataWatcherConverter;
import info.cho.passwords.fairy.bukkit.mc.entity.BukkitEntityIDCounter;
import info.cho.passwords.fairy.bukkit.mc.operator.BukkitMCPlayerOperator;
import info.cho.passwords.fairy.bukkit.mc.operator.BukkitMCPlayerOperatorImpl;
import info.cho.passwords.fairy.bukkit.mc.operator.BukkitMCPlayerPlatformOperator;
import info.cho.passwords.fairy.bukkit.mc.registry.BukkitMCEntityRegistry;
import info.cho.passwords.fairy.bukkit.mc.registry.BukkitMCGameProfileRegistry;
import info.cho.passwords.fairy.bukkit.mc.registry.BukkitMCWorldRegistry;
import info.cho.passwords.fairy.bukkit.nms.BukkitNMSManager;
import info.cho.passwords.fairy.bukkit.nms.BukkitNMSManagerImpl;
import info.cho.passwords.fairy.container.InjectableComponent;
import info.cho.passwords.fairy.container.configuration.Configuration;
import info.cho.passwords.fairy.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import info.cho.passwords.fairy.libs.kyori.adventure.text.serializer.gson.legacyimpl.NBTLegacyHoverEventSerializer;
import info.cho.passwords.fairy.mc.MCAdventure;
import info.cho.passwords.fairy.mc.MCServer;
import info.cho.passwords.fairy.mc.entity.EntityIDCounter;
import info.cho.passwords.fairy.mc.registry.MCEntityRegistry;
import info.cho.passwords.fairy.mc.registry.MCGameProfileRegistry;
import info.cho.passwords.fairy.mc.registry.MCWorldRegistry;
import info.cho.passwords.fairy.mc.registry.player.MCPlayerPlatformOperator;
import info.cho.passwords.fairy.mc.scheduler.MCSchedulerProvider;
import info.cho.passwords.fairy.mc.version.MCVersionMappingRegistry;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

@Configuration
public class BukkitMCConfiguration {
    @InjectableComponent
    public Server provideBukkitServer() {
        return Bukkit.getServer();
    }

    @InjectableComponent
    public MCServer provideMCServer(Server server) {
        return new BukkitMCServer(server);
    }

    @InjectableComponent
    public BukkitNMSManager provideNMSManager(MCServer mcServer, MCVersionMappingRegistry registry, Server server) {
        return new BukkitNMSManagerImpl(mcServer, registry, server.getClass());
    }

    @InjectableComponent
    public BukkitMCPlayerOperator providePlayerOperator(BukkitNMSManager nmsManager) {
        return new BukkitMCPlayerOperatorImpl(nmsManager);
    }

    @InjectableComponent
    public BukkitDataWatcherConverter provideDataWatcherConverter(BukkitNMSManager nmsManager) {
        return new BukkitDataWatcherConverter(nmsManager);
    }

    @InjectableComponent
    public EntityIDCounter provideEntityIDCounter(BukkitNMSManager nmsManager) {
        return new BukkitEntityIDCounter(nmsManager);
    }

    @InjectableComponent
    public MCAdventure.AdventureHook provideAdventureHook() {
        return MCAdventure.AdventureHook.builder().serializer(NBTLegacyHoverEventSerializer.get()).build();
    }

    @InjectableComponent
    public MCEntityRegistry provideEntityRegistry(BukkitDataWatcherConverter dataWatcherConverter, MCSchedulerProvider mcSchedulerProvider) {
        return new BukkitMCEntityRegistry(dataWatcherConverter, mcSchedulerProvider);
    }

    @InjectableComponent
    public MCWorldRegistry provideWorldRegistry(BukkitAudiences bukkitAudiences) {
        return new BukkitMCWorldRegistry(bukkitAudiences);
    }

    @InjectableComponent
    public MCPlayerPlatformOperator provideMCPlayerPlatformOperator(MCServer mcServer, BukkitAudiences audiences, BukkitDataWatcherConverter dataWatcherConverter, BukkitMCPlayerOperator playerOperator, MCVersionMappingRegistry versionMappingRegistry, MCSchedulerProvider mcSchedulerProvider) {
        return new BukkitMCPlayerPlatformOperator(mcServer, audiences, dataWatcherConverter, playerOperator, mcSchedulerProvider, versionMappingRegistry);
    }

    @InjectableComponent
    public MCGameProfileRegistry provideGameProfileBridge() {
        return new BukkitMCGameProfileRegistry();
    }

    @InjectableComponent
    public BukkitAudiences provideBukkitAudiences() {
        return BukkitAudiences.create((Plugin)FairyBukkitPlatform.PLUGIN);
    }
}

