/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.gui;

import info.cho.passwords.fairy.bukkit.events.BukkitEventFilter;
import info.cho.passwords.fairy.bukkit.events.BukkitEventNode;
import info.cho.passwords.fairy.bukkit.gui.event.GuiCloseEvent;
import info.cho.passwords.fairy.bukkit.gui.event.GuiOpenEvent;
import info.cho.passwords.fairy.bukkit.gui.pane.Pane;
import info.cho.passwords.fairy.bukkit.gui.slot.GuiSlot;
import info.cho.passwords.fairy.data.MetaStorage;
import info.cho.passwords.fairy.event.EventNode;
import info.cho.passwords.fairy.libs.kyori.adventure.text.Component;
import info.cho.passwords.fairy.mc.MCAdventure;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.scheduler.MCSchedulers;
import info.cho.passwords.fairy.util.ConditionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Gui {
    private static final AtomicInteger ID_COUNTER = new AtomicInteger();
    private final int id = ID_COUNTER.getAndIncrement();
    private final MetaStorage metaStorage;
    private final BukkitEventNode bukkitEventNode;
    private final Map<Integer, EventNode<InventoryEvent>> slotEventNodes;
    private final List<Consumer<Player>> openCallbacks;
    private final List<Consumer<Player>> drawCallbacks;
    private final List<Consumer<Player>> closeCallbacks;
    private final List<Pane> panes;
    private final boolean[] usedSlots;
    private Component title;
    @Nullable
    private Inventory inventory;
    private GuiSlot[] guiSlots;
    private EventNode<Event> eventNode;
    private boolean titleUpdating;
    private int maxSlots;

    public Gui(BukkitEventNode bukkitEventNode, Component title) {
        this.bukkitEventNode = bukkitEventNode;
        this.openCallbacks = new ArrayList<Consumer<Player>>();
        this.drawCallbacks = new ArrayList<Consumer<Player>>();
        this.closeCallbacks = new ArrayList<Consumer<Player>>();
        this.metaStorage = MetaStorage.create();
        this.slotEventNodes = new HashMap<Integer, EventNode<InventoryEvent>>();
        this.title = title;
        this.panes = new ArrayList<Pane>();
        this.usedSlots = new boolean[54];
        this.maxSlots = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTitle(@NotNull Player player, @NotNull Component title) {
        this.title = title;
        if (!this.isOpening() || this.titleUpdating) {
            return;
        }
        this.titleUpdating = true;
        MCPlayer mcPlayer = MCPlayer.from(player);
        try {
            this.inventory = Bukkit.createInventory(null, (int)(this.getRows() * 9), (String)MCAdventure.asLegacyString(this.title, mcPlayer.getLocale()));
            this.renderSlots(player);
            player.openInventory(this.inventory);
        }
        finally {
            this.titleUpdating = false;
        }
    }

    public void openOrUpdate(Player player) {
        if (this.isOpening()) {
            this.update(player);
        } else {
            this.open(player);
        }
    }

    public void open(Player player) {
        if (this.isOpening()) {
            return;
        }
        MCPlayer mcPlayer = MCPlayer.from(player);
        GuiOpenEvent event = new GuiOpenEvent(player, this);
        event.call();
        if (event.isCancelled()) {
            return;
        }
        this.inventory = Bukkit.createInventory(null, (int)(this.getRows() * 9), (String)MCAdventure.asLegacyString(this.title, mcPlayer.getLocale()));
        this.guiSlots = new GuiSlot[this.maxSlots + 1];
        this.registerListeners();
        this.update(player);
        player.openInventory(this.inventory);
        this.onOpen(player);
    }

    public void update(Player player) {
        if (!this.isOpening()) {
            return;
        }
        this.drawCallbacks.forEach(callback -> callback.accept(player));
        for (Pane pane : this.panes) {
            this.renderPane(pane);
        }
        this.renderSlots(player);
    }

    private void close(Player player) {
        Arrays.fill(this.usedSlots, false);
        if (this.eventNode != null) {
            this.eventNode.closeAndReportException();
        }
        this.eventNode = null;
        this.inventory = null;
        this.guiSlots = null;
        new GuiCloseEvent(player, this).call();
        MCSchedulers.getGlobalScheduler().schedule(() -> this.onClose(player), 1L);
    }

    public void onOpenCallback(Consumer<Player> callback) {
        this.openCallbacks.add(callback);
    }

    public void onDrawCallback(Consumer<Player> callback) {
        this.drawCallbacks.add(callback);
    }

    public void onCloseCallback(Consumer<Player> callback) {
        this.closeCallbacks.add(callback);
    }

    public boolean isInventory(Inventory inventory) {
        return Objects.equals(this.inventory, inventory);
    }

    @Nullable
    public ItemStack getItem(int slot) {
        if (this.inventory == null) {
            return null;
        }
        return this.inventory.getItem(slot);
    }

    public <T extends GuiSlot> void forEachGuiSlots(Class<T> aClass, BiConsumer<Integer, T> callback) {
        if (this.guiSlots == null) {
            return;
        }
        for (int i = 0; i < this.guiSlots.length; ++i) {
            GuiSlot guiSlot = this.guiSlots[i];
            if (guiSlot == null || !aClass.isInstance(guiSlot)) continue;
            callback.accept(i, (Integer)((Object)((GuiSlot)aClass.cast(guiSlot))));
        }
    }

    public void addPane(Pane pane) {
        this.panes.add(pane);
        for (int slot : pane.getUsedSlots()) {
            ConditionUtils.is(slot >= 0 && slot < 54, "Slot " + slot + " is not in the inventory");
            ConditionUtils.is(!this.usedSlots[slot], "Slot " + slot + " is already used");
            this.usedSlots[slot] = true;
            if (slot <= this.maxSlots) continue;
            this.maxSlots = slot;
        }
    }

    public <T extends Pane> T getPane(Class<T> clazz) {
        for (Pane pane : this.panes) {
            if (!clazz.isInstance(pane)) continue;
            return (T)((Pane)clazz.cast(pane));
        }
        return null;
    }

    public void updateSlot(@NotNull Player player, int slot, @Nullable GuiSlot guiSlot) {
        ConditionUtils.notNull(this.inventory, "Inventory is null");
        ItemStack previous = this.inventory.getItem(slot);
        ItemStack current = null;
        if (guiSlot != null) {
            current = guiSlot.getItemStack(player, this);
        }
        if (previous != null && previous.equals((Object)current)) {
            return;
        }
        this.inventory.setItem(slot, current);
    }

    public int getRows() {
        return (int)Math.ceil((double)this.maxSlots / 9.0);
    }

    private void renderSlots(Player player) {
        if (this.inventory == null) {
            return;
        }
        for (int i = 0; i < this.guiSlots.length; ++i) {
            GuiSlot guiSlot = this.guiSlots[i];
            this.updateSlot(player, i, guiSlot);
        }
    }

    private void renderPane(Pane pane) {
        for (int slot : pane.getUsedSlots()) {
            GuiSlot guiSlot = pane.getSlot(slot);
            if (guiSlot == null) {
                if (this.guiSlots[slot] != null) {
                    this.onSlotRemoved(slot);
                }
                this.guiSlots[slot] = null;
                continue;
            }
            if (this.guiSlots[slot] != null) {
                this.onSlotRemoved(slot);
            }
            this.guiSlots[slot] = guiSlot;
            this.onSlotAdd(slot, guiSlot);
        }
    }

    private void onSlotAdd(int slot, GuiSlot guiSlot) {
        EventNode<InventoryEvent> eventNode = guiSlot.getEventNode(this);
        if (eventNode != null) {
            this.slotEventNodes.put(slot, eventNode);
            this.eventNode.addChild(eventNode);
        }
    }

    private void onSlotRemoved(int slot) {
        EventNode<InventoryEvent> eventNode = this.slotEventNodes.remove(slot);
        if (eventNode != null) {
            eventNode.closeAndReportException();
        }
    }

    private void registerListeners() {
        this.eventNode = EventNode.create(String.format("fairy:gui-%d", this.id), BukkitEventFilter.ALL, null);
        this.eventNode.addListener(GuiOpenEvent.class, this::onGuiOpen);
        this.eventNode.addListener(PlayerQuitEvent.class, this::onPlayerQuit);
        this.eventNode.addListener(InventoryClickEvent.class, this::onInventoryClick);
        this.eventNode.addListener(InventoryDragEvent.class, this::onInventoryDrag);
        this.eventNode.addListener(InventoryCloseEvent.class, this::onInventoryClose);
        this.bukkitEventNode.addChild(this.eventNode);
    }

    private void onGuiOpen(@NotNull GuiOpenEvent event) {
        Gui gui = event.getGui();
        if (gui == this) {
            return;
        }
        if (this.inventory == null) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.inventory.getViewers().contains(player)) {
            return;
        }
        this.close(player);
    }

    private void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        assert (this.inventory != null);
        Player player = event.getPlayer();
        if (!this.inventory.getViewers().contains(player)) {
            return;
        }
        this.close(player);
    }

    private void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (this.titleUpdating) {
            return;
        }
        if (!this.isInventory(event.getInventory())) {
            return;
        }
        this.close(player);
    }

    private void onInventoryClick(@NotNull InventoryClickEvent event) {
        if (!this.isInventory(this.getOpenedTopInventory(event.getWhoClicked()))) {
            return;
        }
        if (this.isTryingToShiftItemFromPlayerInvToGui(event) || this.isNotClickingGuiInvWhileOpenIt(event)) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        int slot = event.getSlot();
        if (slot < 0 || slot >= this.usedSlots.length) {
            return;
        }
        GuiSlot guiSlot = this.guiSlots[slot];
        if (guiSlot == null) {
            return;
        }
        guiSlot.onInventoryClick(event, this);
    }

    private boolean isNotClickingGuiInvWhileOpenIt(InventoryClickEvent event) {
        return !this.isInventory(event.getClickedInventory()) && this.isInventory(this.getOpenedTopInventory(event.getWhoClicked()));
    }

    private boolean isTryingToShiftItemFromPlayerInvToGui(InventoryClickEvent event) {
        if (this.isInventory(event.getClickedInventory())) {
            return false;
        }
        if (!this.isInventory(this.getOpenedTopInventory(event.getWhoClicked()))) {
            return false;
        }
        switch (event.getAction()) {
            case COLLECT_TO_CURSOR: 
            case MOVE_TO_OTHER_INVENTORY: 
            case UNKNOWN: {
                return true;
            }
        }
        return false;
    }

    private Inventory getOpenedTopInventory(HumanEntity player) {
        InventoryView view = player.getOpenInventory();
        return view == null ? null : view.getTopInventory();
    }

    private void onInventoryDrag(@NotNull InventoryDragEvent event) {
        if (!this.isInventory(event.getInventory())) {
            return;
        }
        InventoryView view = event.getView();
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            Inventory currentInventory = this.getInventory(view, slot);
            if (!this.isInventory(currentInventory)) {
                return;
            }
            GuiSlot guiSlot = this.guiSlots[slot];
            if (guiSlot == null) {
                event.setCancelled(true);
                return;
            }
            if (!guiSlot.onInventoryDrag(event, this)) continue;
            event.setCancelled(true);
        }
    }

    public final Inventory getInventory(InventoryView view, int rawSlot) {
        if (rawSlot == -1) {
            return null;
        }
        if (rawSlot < view.getTopInventory().getSize()) {
            return view.getTopInventory();
        }
        return view.getBottomInventory();
    }

    private void onOpen(Player player) {
        this.openCallbacks.forEach(callback -> callback.accept(player));
    }

    private void onClose(Player player) {
        this.closeCallbacks.forEach(callback -> callback.accept(player));
    }

    public boolean isOpening() {
        return this.inventory != null;
    }

    public int getId() {
        return this.id;
    }

    public MetaStorage getMetaStorage() {
        return this.metaStorage;
    }

    public EventNode<Event> getEventNode() {
        return this.eventNode;
    }
}

