/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.gui.pane.mapping;

import info.cho.passwords.fairy.bukkit.gui.pane.mapping.PaneMapping;

public class RectanglePaneMapping
implements PaneMapping {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private int[] cachedSlots;

    @Override
    public int getSize() {
        return this.width * this.height;
    }

    @Override
    public int[] getSlots() {
        if (this.cachedSlots == null) {
            this.cachedSlots = new int[this.width * this.height];
            for (int i = 0; i < this.cachedSlots.length; ++i) {
                this.cachedSlots[i] = this.getSlot(i);
            }
        }
        return this.cachedSlots;
    }

    @Override
    public int getSlot(int index) {
        return this.x + index % this.width + (this.y + index / this.width) * 9;
    }

    @Override
    public int getIndex(int slot) {
        return slot % 9 - this.x + (slot / 9 - this.y) * this.width;
    }

    @Override
    public int getSlot(int x, int y) {
        return this.getSlot(x + y * this.width);
    }

    @Override
    public boolean hasAxis() {
        return true;
    }

    public RectanglePaneMapping(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }
}

