/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.listener;

import com.google.common.collect.ImmutableSet;
import info.cho.passwords.fairy.bukkit.listener.FilteredEventList;
import info.cho.passwords.fairy.bukkit.listener.FilteredListener;
import info.cho.passwords.fairy.bukkit.listener.annotation.IgnoredFilters;
import info.cho.passwords.fairy.bukkit.listener.asm.MethodHandleEventExecutor;
import info.cho.passwords.fairy.bukkit.listener.asm.StaticMethodHandleEventExecutor;
import info.cho.passwords.fairy.bukkit.listener.timings.TimedEventExecutor;
import info.cho.passwords.fairy.util.AccessUtil;
import info.cho.passwords.fairy.util.ConditionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public final class FilteredListenerRegistry {
    public static final FilteredListenerRegistry INSTANCE = new FilteredListenerRegistry();

    public void register(FilteredListener<?> filteredListener) {
        this.register((Listener)filteredListener, (Plugin)filteredListener.plugin, filteredListener.getEventList());
    }

    public <L extends Listener> void register(L listener, Plugin plugin, FilteredEventList eventList) {
        ImmutableSet methods;
        HashMap<Class, Set> ret = new HashMap<Class, Set>();
        try {
            Method[] publicMethods = listener.getClass().getMethods();
            Method[] methodArray = listener.getClass().getDeclaredMethods();
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Method method : publicMethods) {
                builder.add((Object)method);
            }
            for (Method method : methodArray) {
                builder.add((Object)method);
            }
            methods = builder.build();
        }
        catch (NoClassDefFoundError e) {
            plugin.getLogger().severe("Plugin " + plugin.getDescription().getFullName() + " has failed to register events for " + listener.getClass() + " because " + e.getMessage() + " does not exist.");
            return;
        }
        for (Method method : methods) {
            Class<?> checkClass;
            EventHandler eventHandler = method.getAnnotation(EventHandler.class);
            if (eventHandler == null || method.isBridge() || method.isSynthetic()) continue;
            if (method.getParameterTypes().length != 1 || !Event.class.isAssignableFrom(checkClass = method.getParameterTypes()[0])) {
                plugin.getLogger().severe(plugin.getDescription().getFullName() + " attempted to register an invalid EventHandler method signature \"" + method.toGenericString() + "\" in " + listener.getClass());
                continue;
            }
            Class<Event> eventClass = checkClass.asSubclass(Event.class);
            method.setAccessible(true);
            Set eventSet = ret.computeIfAbsent(eventClass, k -> new HashSet());
            boolean ignoredFilters = method.getAnnotation(IgnoredFilters.class) != null;
            TimedEventExecutor executor = new TimedEventExecutor(this.create(method, eventClass, ignoredFilters, eventList), plugin, method, eventClass);
            eventSet.add(new RegisteredListener(listener, (EventExecutor)executor, eventHandler.priority(), plugin, eventHandler.ignoreCancelled()));
        }
        for (Map.Entry entry : ret.entrySet()) {
            FilteredListenerRegistry.getHandlerList((Class)entry.getKey()).registerAll((Collection)entry.getValue());
        }
    }

    @NonNull
    private EventExecutor create(@NonNull Method m, @NonNull Class<? extends Event> eventClass, boolean ignoredFilters, FilteredEventList eventList) {
        if (m == null) {
            throw new NullPointerException("m is marked non-null but is null");
        }
        if (eventClass == null) {
            throw new NullPointerException("eventClass is marked non-null but is null");
        }
        ConditionUtils.notNull(m, "Null method");
        ConditionUtils.is(m.getParameterCount() != 0, "Incorrect number of arguments %s", (Object)m.getParameterCount());
        ConditionUtils.is(m.getParameterTypes()[0] == eventClass, "First parameter %s doesn't match event class %s", m.getParameterTypes()[0], eventClass);
        if (Modifier.isStatic(m.getModifiers())) {
            return new StaticMethodHandleEventExecutor(eventClass, m, ignoredFilters, eventList);
        }
        return new MethodHandleEventExecutor(eventClass, m, ignoredFilters, eventList);
    }

    private static HandlerList getHandlerList(Class<? extends Event> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("getHandlerList", new Class[0]);
            AccessUtil.setAccessible(method);
            return (HandlerList)method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Event.class) && Event.class.isAssignableFrom(clazz.getSuperclass())) {
                return FilteredListenerRegistry.getHandlerList(clazz.getSuperclass().asSubclass(Event.class));
            }
            throw new IllegalPluginAccessException("Unable to find handler list for event " + clazz.getName() + ". Static getHandlerList method required!");
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("An error occurs while invoking for getHandlerList()", e);
        }
    }

    private FilteredListenerRegistry() {
    }
}

