/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.listener.events;

import com.google.common.base.Preconditions;
import info.cho.passwords.fairy.bukkit.listener.events.EventSubscription;
import info.cho.passwords.fairy.bukkit.listener.events.Events;
import info.cho.passwords.fairy.bukkit.listener.events.ExpiryStage;
import info.cho.passwords.fairy.bukkit.player.PlayerEventRecognizer;
import info.cho.passwords.fairy.util.terminable.TerminableConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;

@Deprecated
public class EventSubscribeBuilder<T extends Event> {
    private final Class<T> eventType;
    private EventPriority priority;
    private boolean handleSubClasses;
    private BiConsumer<? super T, Throwable> exceptionHandler = (t, throwable) -> {
        throw new RuntimeException((Throwable)throwable);
    };
    private final List<Predicate<T>> filters;
    private final List<BiPredicate<EventSubscription<T>, T>> beforeExpiryTest;
    private final List<BiPredicate<EventSubscription<T>, T>> midExpiryTest;
    private final List<BiPredicate<EventSubscription<T>, T>> postExpiryTest;
    private final List<BiConsumer<EventSubscription<T>, ? super T>> handlers;
    private Plugin plugin;
    private TerminableConsumer bindWith;

    public EventSubscribeBuilder(Class<T> type) {
        this.eventType = type;
        this.priority = EventPriority.NORMAL;
        this.filters = new ArrayList<Predicate<T>>(0);
        this.beforeExpiryTest = new ArrayList<BiPredicate<EventSubscription<T>, T>>(0);
        this.midExpiryTest = new ArrayList<BiPredicate<EventSubscription<T>, T>>(0);
        this.postExpiryTest = new ArrayList<BiPredicate<EventSubscription<T>, T>>(0);
        this.handlers = new ArrayList<BiConsumer<EventSubscription<T>, ? super T>>(1);
    }

    public EventSubscribeBuilder(EventSubscribeBuilder<T> original) {
        this.eventType = original.getEventType();
        this.priority = original.getPriority();
        this.filters = original.getFilters();
        this.beforeExpiryTest = original.getBeforeExpiryTest();
        this.midExpiryTest = original.getMidExpiryTest();
        this.postExpiryTest = original.getPostExpiryTest();
        this.handlers = original.getHandlers();
        this.handleSubClasses = original.isHandleSubClasses();
        this.exceptionHandler = original.getExceptionHandler();
        this.plugin = original.getPlugin();
        this.bindWith = original.getBindWith();
    }

    public EventSubscribeBuilder<T> priority(EventPriority priority) {
        this.priority = priority;
        return this;
    }

    public EventSubscribeBuilder<T> filter(Predicate<T> filter) {
        this.filters.add(filter);
        return this;
    }

    public EventSubscribeBuilder<T> handleException(BiConsumer<? super T, Throwable> consumer) {
        this.exceptionHandler = consumer;
        return this;
    }

    public EventSubscribeBuilder<T> handleSubClasses() {
        this.handleSubClasses = true;
        return this;
    }

    public EventSubscribeBuilder<T> expireAfter(long duration, @NonNull TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        Preconditions.checkArgument((duration >= 1L ? 1 : 0) != 0, (Object)"duration < 1");
        long expiry = Math.addExact(System.currentTimeMillis(), unit.toMillis(duration));
        return this.expireIf((handler, event) -> System.currentTimeMillis() > expiry, ExpiryStage.BEOFORE);
    }

    public EventSubscribeBuilder<T> expireAfterAccess(long maxCalls) {
        Preconditions.checkArgument((maxCalls >= 1L ? 1 : 0) != 0, (Object)"maxCalls < 1");
        return this.expireIf((handler, event) -> (long)handler.getAccessCount() >= maxCalls, ExpiryStage.BEOFORE, ExpiryStage.POST_EXECUTE);
    }

    public PlayerEventSubscribeBuilder forPlayer(Player player) {
        return this.forPlayer(player, null);
    }

    public PlayerEventSubscribeBuilder forPlayer(Player player, String metadata) {
        return new PlayerEventSubscribeBuilder(this, player, metadata);
    }

    public EventSubscribeBuilder<T> expireIf(@NonNull BiPredicate<EventSubscription<T>, T> predicate, ExpiryStage ... stages) {
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        block5: for (ExpiryStage stage : stages) {
            switch (stage) {
                case BEOFORE: {
                    this.beforeExpiryTest.add(predicate);
                    continue block5;
                }
                case POST_FILTER: {
                    this.midExpiryTest.add(predicate);
                    continue block5;
                }
                case POST_EXECUTE: {
                    this.postExpiryTest.add(predicate);
                }
            }
        }
        return this;
    }

    @SafeVarargs
    public final EventSubscribeBuilder<T> listen(BiConsumer<EventSubscription<T>, T> ... listeners) {
        this.handlers.addAll(Arrays.asList(listeners));
        return this;
    }

    @SafeVarargs
    public final EventSubscribeBuilder<T> listen(Consumer<T> ... listeners) {
        this.handlers.addAll(Stream.of(listeners).map(consumer -> (tEventSubscription, t) -> consumer.accept(t)).collect(Collectors.toList()));
        return this;
    }

    public final EventSubscribeBuilder<T> plugin(Plugin plugin) {
        this.plugin = plugin;
        return this;
    }

    public final EventSubscribeBuilder<T> bindWith(TerminableConsumer terminableConsumer) {
        this.bindWith = terminableConsumer;
        return this;
    }

    public EventSubscription<T> build(Plugin plugin) {
        this.plugin = plugin;
        return this.build();
    }

    public EventSubscription<T> build() {
        if (this.plugin == null) {
            throw new IllegalArgumentException("No plugin were registered in EventSubscribeBuilder.");
        }
        EventSubscription subscription = new EventSubscription(this);
        subscription.register(this.plugin);
        if (this.bindWith != null) {
            subscription.bindWith(this.bindWith);
        }
        return subscription;
    }

    public Class<T> getEventType() {
        return this.eventType;
    }

    public EventPriority getPriority() {
        return this.priority;
    }

    public boolean isHandleSubClasses() {
        return this.handleSubClasses;
    }

    public BiConsumer<? super T, Throwable> getExceptionHandler() {
        return this.exceptionHandler;
    }

    public List<Predicate<T>> getFilters() {
        return this.filters;
    }

    public List<BiPredicate<EventSubscription<T>, T>> getBeforeExpiryTest() {
        return this.beforeExpiryTest;
    }

    public List<BiPredicate<EventSubscription<T>, T>> getMidExpiryTest() {
        return this.midExpiryTest;
    }

    public List<BiPredicate<EventSubscription<T>, T>> getPostExpiryTest() {
        return this.postExpiryTest;
    }

    public List<BiConsumer<EventSubscription<T>, ? super T>> getHandlers() {
        return this.handlers;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public TerminableConsumer getBindWith() {
        return this.bindWith;
    }

    public class PlayerEventSubscribeBuilder
    extends EventSubscribeBuilder<T> {
        private final Player player;
        private final String metadata;
        private final List<Class<PlayerEventRecognizer.Attribute<?>>> recognizeAttributes;

        public PlayerEventSubscribeBuilder(EventSubscribeBuilder<T> original, Player player, String metadata) {
            super(original);
            this.player = player;
            this.metadata = metadata;
            this.recognizeAttributes = new ArrayList(0);
        }

        public PlayerEventSubscribeBuilder recognizeAttribute(Class<PlayerEventRecognizer.Attribute<?>> ... attributes) {
            this.recognizeAttributes.addAll(Arrays.asList(attributes));
            return this;
        }

        @Override
        public EventSubscription<T> build(Plugin plugin) {
            if (this.recognizeAttributes.isEmpty() && !PlayerEventRecognizer.isTypePossible(this.getEventType())) {
                throw new IllegalStateException("used forPlayer() but type " + this.getEventType().getSimpleName() + " seems to be impossible to get Player!");
            }
            this.filter(new PlayerPredicate(this.player.getUniqueId(), this.recognizeAttributes.toArray(new Class[0])));
            EventSubscription subscription = new EventSubscription(this);
            subscription.register(plugin);
            if (this.metadata != null) {
                Events.getSubscriptionList(this.player).put(this.metadata, subscription);
            }
            return subscription;
        }

        public Player getPlayer() {
            return this.player;
        }

        public String getMetadata() {
            return this.metadata;
        }

        public List<Class<PlayerEventRecognizer.Attribute<?>>> getRecognizeAttributes() {
            return this.recognizeAttributes;
        }
    }

    private static class PlayerPredicate<T extends Event>
    implements Predicate<T> {
        private final UUID uuid;
        private final Class<PlayerEventRecognizer.Attribute<?>>[] attributes;

        @Override
        public boolean test(T event) {
            Player player = PlayerEventRecognizer.tryRecognize(event, this.attributes);
            if (player != null) {
                return player.getUniqueId().equals(this.uuid);
            }
            return false;
        }

        public PlayerPredicate(UUID uuid, Class<PlayerEventRecognizer.Attribute<?>>[] attributes) {
            this.uuid = uuid;
            this.attributes = attributes;
        }
    }
}

