/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.listener.events;

import info.cho.passwords.fairy.FairyPlatform;
import info.cho.passwords.fairy.bukkit.FairyBukkitPlatform;
import info.cho.passwords.fairy.bukkit.listener.ListenerSubscription;
import info.cho.passwords.fairy.bukkit.listener.events.EventSubscribeBuilder;
import info.cho.passwords.fairy.bukkit.listener.events.EventSubscription;
import info.cho.passwords.fairy.bukkit.listener.events.EventSubscriptionList;
import info.cho.passwords.fairy.bukkit.metadata.Metadata;
import info.cho.passwords.fairy.bukkit.util.JavaPluginUtil;
import info.cho.passwords.fairy.container.Autowired;
import info.cho.passwords.fairy.log.Log;
import info.cho.passwords.fairy.metadata.MetadataKey;
import info.cho.passwords.fairy.util.terminable.TerminableConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

@Deprecated
public final class Events {
    public static final MetadataKey<EventSubscriptionList> SUBSCRIPTION_LIST = MetadataKey.create("fairy:SubscriptionList", EventSubscriptionList.class);
    public static final Predicate<PlayerLoginEvent> IGNORE_DISALLOWED_LOGIN = e -> e.getResult() == PlayerLoginEvent.Result.ALLOWED;
    public static final Predicate<AsyncPlayerPreLoginEvent> IGNORE_DISALLOWED_PRE_LOGIN = e -> e.getLoginResult() == AsyncPlayerPreLoginEvent.Result.ALLOWED;
    public static final Predicate<PlayerMoveEvent> IGNORE_SAME_BLOCK = e -> e.getFrom().getBlockX() != e.getTo().getBlockX() || e.getFrom().getBlockZ() != e.getTo().getBlockZ() || e.getFrom().getBlockY() != e.getTo().getBlockY() || !e.getFrom().getWorld().equals((Object)e.getTo().getWorld());
    public static final Predicate<PlayerMoveEvent> IGNORE_SAME_BLOCK_AND_Y = e -> e.getFrom().getBlockX() != e.getTo().getBlockX() || e.getFrom().getBlockZ() != e.getTo().getBlockZ() || !e.getFrom().getWorld().equals((Object)e.getTo().getWorld());
    public static final Predicate<PlayerMoveEvent> IGNORE_SAME_CHUNK = e -> e.getFrom().getBlockX() >> 4 != e.getTo().getBlockX() >> 4 || e.getFrom().getBlockZ() >> 4 != e.getTo().getBlockZ() >> 4 || !e.getFrom().getWorld().equals((Object)e.getTo().getWorld());
    @Autowired
    private static FairyPlatform platform;

    public static <T extends Cancellable> Consumer<T> cancel() {
        return event -> event.setCancelled(true);
    }

    public static <T extends Cancellable> Predicate<T> ignoreCancelled() {
        return e -> !e.isCancelled();
    }

    public static <T extends Cancellable> Predicate<T> ignoreUncancelled() {
        return Cancellable::isCancelled;
    }

    public static ListenerSubscription subscribe(Listener ... listeners) {
        if (listeners.length == 0) {
            return null;
        }
        Listener mainListener = listeners[0];
        JavaPlugin plugin = JavaPluginUtil.getProvidingPlugin(mainListener.getClass());
        if (plugin == null) {
            plugin = FairyBukkitPlatform.PLUGIN;
        }
        if (!plugin.isEnabled()) {
            Log.error("The plugin hasn't enabled but trying to register listener " + mainListener.getClass().getSimpleName(), new Object[0]);
        }
        TerminableConsumer terminable = platform;
        if (plugin instanceof TerminableConsumer) {
            terminable = (TerminableConsumer)plugin;
        }
        ListenerSubscription listenerSubscription = new ListenerSubscription(listeners, (Plugin)plugin, terminable);
        listenerSubscription.register();
        return listenerSubscription;
    }

    public static <T extends Event> T call(T t) {
        Bukkit.getPluginManager().callEvent(t);
        return t;
    }

    public static <T extends Event> EventSubscribeBuilder<T> subscribe(Class<T> type) {
        return new EventSubscribeBuilder<T>(type);
    }

    public static Predicate<? extends PlayerEvent> onlyForPlayer(Player player) {
        return playerEvent -> playerEvent.getPlayer() == player;
    }

    @Nullable
    public static EventSubscription<?> getSubscription(Player player, String metadata) {
        return Events.getSubscriptionList(player).get(metadata);
    }

    public static EventSubscriptionList getSubscriptionList(Player player) {
        return Metadata.provideForPlayer(player).getOrPut(SUBSCRIPTION_LIST, EventSubscriptionList::new);
    }

    public static void unregisterAll(Player player) {
        Events.getSubscriptionList(player).clear();
    }

    private Events() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

