/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.mc.entity;

import info.cho.passwords.fairy.bukkit.nms.BukkitNMSManager;
import info.cho.passwords.fairy.bukkit.reflection.MinecraftReflection;
import info.cho.passwords.fairy.bukkit.reflection.resolver.ConstructorResolver;
import info.cho.passwords.fairy.bukkit.reflection.resolver.FieldResolver;
import info.cho.passwords.fairy.bukkit.reflection.resolver.MethodResolver;
import info.cho.passwords.fairy.bukkit.reflection.resolver.ResolverQuery;
import info.cho.passwords.fairy.bukkit.reflection.wrapper.ConstructorWrapper;
import info.cho.passwords.fairy.bukkit.reflection.wrapper.FieldWrapper;
import info.cho.passwords.fairy.bukkit.reflection.wrapper.MethodWrapper;
import info.cho.passwords.fairy.libs.packetevents.PacketEvents;
import info.cho.passwords.fairy.libs.packetevents.protocol.entity.data.EntityData;
import info.cho.passwords.fairy.libs.packetevents.wrapper.PacketWrapper;
import info.cho.passwords.fairy.util.AccessUtil;
import info.cho.passwords.fairy.util.exceptionally.ThrowingFunction;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class BukkitDataWatcherConverter {
    private final BukkitNMSManager bukkitNMSManager;
    private Function<Entity, List<EntityData>> converter;

    public Class<?> getPacketDataSerializerClass() throws ClassNotFoundException {
        return this.bukkitNMSManager.getNmsClassResolver().resolve("network.PacketDataSerializer", "network.FriendlyByteBuf", "PacketDataSerializer");
    }

    public Class<?> getEntityClass() throws ClassNotFoundException {
        return this.bukkitNMSManager.getNmsClassResolver().resolve("world.entity.Entity", "Entity");
    }

    public Class<?> getDataWatcherClass() throws ClassNotFoundException {
        return this.bukkitNMSManager.getNmsClassResolver().resolve("network.syncher.DataWatcher", "network.syncher.SynchedEntityData", "DataWatcher");
    }

    @NotNull
    public List<EntityData> convert(@NotNull Entity entity) throws ReflectiveOperationException {
        if (this.converter == null) {
            Class<?> entityClass = this.getEntityClass();
            Class<?> dataWatcherClass = this.getDataWatcherClass();
            Class<?> packetDataSerializerClass = this.getPacketDataSerializerClass();
            Class<?> byteBufClass = Class.forName("io.netty.buffer.ByteBuf");
            Field field = new FieldResolver(entityClass).resolveByFirstType(dataWatcherClass);
            AccessUtil.setAccessible(field);
            FieldWrapper dataWatcherField = new FieldWrapper(field);
            ConstructorWrapper packetDataSerializerConstructor = new ConstructorResolver(packetDataSerializerClass).resolveWrapper(new Class[][]{{byteBufClass}});
            try {
                this.findConverterPre1_13(dataWatcherClass, packetDataSerializerClass, dataWatcherField, packetDataSerializerConstructor);
            }
            catch (Throwable throwable) {
                Method dataWatcherPackDirtyMethod = new MethodResolver(dataWatcherClass).resolve(new ResolverQuery(List.class, 0).withModifierOptions(ResolverQuery.ModifierOptions.builder().onlyDynamic(true).build()));
                this.findConverterModern(dataWatcherClass, packetDataSerializerClass, dataWatcherField, packetDataSerializerConstructor, dataWatcherPackDirtyMethod);
            }
        }
        return this.converter.apply(entity);
    }

    private void findConverterModern(Class<?> dataWatcherClass, Class<?> packetDataSerializerClass, FieldWrapper<?> dataWatcherField, ConstructorWrapper<?> packetDataSerializerConstructor, Method dataWatcherPackDirtyMethod) throws NoSuchMethodException {
        Method dataWatcherPackMethod;
        try {
            dataWatcherPackMethod = new MethodResolver(dataWatcherClass).resolve(new ResolverQuery(Void.TYPE, 0, List.class, packetDataSerializerClass).withModifierOptions(ResolverQuery.ModifierOptions.builder().onlyStatic(true).build()));
        }
        catch (Throwable throwable) {
            try {
                Class<?> packetClass = Class.forName("net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata");
                dataWatcherPackMethod = new MethodResolver(packetClass).resolve(new ResolverQuery(Void.TYPE, 0, List.class, packetDataSerializerClass).withModifierOptions(ResolverQuery.ModifierOptions.builder().onlyStatic(true).build()));
            }
            catch (Throwable t) {
                throw new NoSuchMethodException("DataWatcher.pack(List, PacketDataSerializer) method not found");
            }
        }
        Method finalDataWatcherPackMethod = dataWatcherPackMethod;
        this.converter = ThrowingFunction.sneaky(e -> {
            Object handle = MinecraftReflection.getHandle(e);
            Object dataWatcher = dataWatcherField.get(handle);
            Object byteBuf = PacketEvents.getAPI().getNettyManager().getByteBufAllocationOperator().buffer();
            Object packetDataSerializer = packetDataSerializerConstructor.newInstance(byteBuf);
            Object dataItemList = dataWatcherPackDirtyMethod.invoke(dataWatcher, new Object[0]);
            finalDataWatcherPackMethod.invoke(null, dataItemList, packetDataSerializer);
            PacketWrapper<?> packetWrapper = PacketWrapper.createUniversalPacketWrapper(byteBuf);
            return packetWrapper.readEntityMetadata();
        });
    }

    private void findConverterPre1_13(Class<?> dataWatcherClass, Class<?> packetDataSerializerClass, FieldWrapper<?> dataWatcherField, ConstructorWrapper<?> packetDataSerializerConstructor) throws ReflectiveOperationException {
        MethodWrapper dataWatcherWriteMethod = new MethodResolver(dataWatcherClass).resolve(Void.TYPE, 0, packetDataSerializerClass);
        this.converter = ThrowingFunction.sneaky(e -> {
            Object handle = MinecraftReflection.getHandle(e);
            Object dataWatcher = dataWatcherField.get(handle);
            Object byteBuf = PacketEvents.getAPI().getNettyManager().getByteBufAllocationOperator().buffer();
            Object packetDataSerializer = packetDataSerializerConstructor.newInstance(byteBuf);
            dataWatcherWriteMethod.invoke(dataWatcher, packetDataSerializer);
            PacketWrapper<?> packetWrapper = PacketWrapper.createUniversalPacketWrapper(byteBuf);
            return packetWrapper.readEntityMetadata();
        });
    }

    public BukkitDataWatcherConverter(BukkitNMSManager bukkitNMSManager) {
        this.bukkitNMSManager = bukkitNMSManager;
    }
}

