/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.nms;

import info.cho.passwords.fairy.bukkit.nms.BukkitNMSManager;
import info.cho.passwords.fairy.bukkit.reflection.resolver.minecraft.NMSClassResolver;
import info.cho.passwords.fairy.bukkit.reflection.resolver.minecraft.OBCClassResolver;
import info.cho.passwords.fairy.bukkit.version.OBCVersionDecoder;
import info.cho.passwords.fairy.container.PreInitialize;
import info.cho.passwords.fairy.mc.MCServer;
import info.cho.passwords.fairy.mc.version.MCVersionMapping;
import info.cho.passwords.fairy.mc.version.MCVersionMappingRegistry;

public class BukkitNMSManagerImpl
implements BukkitNMSManager {
    private final Class<?> serverClass;
    private final MCServer mcServer;
    private final MCVersionMappingRegistry versionMappingRegistry;
    private NMSClassResolver nmsClassResolver;
    private OBCClassResolver obcClassResolver;

    public BukkitNMSManagerImpl(MCServer mcServer, MCVersionMappingRegistry versionMappingRegistry, Class<?> serverClass) {
        this.serverClass = serverClass;
        this.mcServer = mcServer;
        this.versionMappingRegistry = versionMappingRegistry;
    }

    @PreInitialize
    public void onPreInitialize() {
        this.nmsClassResolver = this.setupNmsClassResolver();
        this.obcClassResolver = this.setupObcClassResolver();
    }

    private OBCClassResolver setupObcClassResolver() {
        return new OBCClassResolver(this.serverClass.getPackage().getName() + ".");
    }

    private NMSClassResolver setupNmsClassResolver() {
        MCVersionMapping mapping = this.versionMappingRegistry.findMapping(this.mcServer.getVersion());
        if (mapping.isNmsPrefix()) {
            String versionFormat = OBCVersionDecoder.create().decode(this.serverClass);
            return new NMSClassResolver("net.minecraft.server." + versionFormat + ".");
        }
        return new NMSClassResolver("net.minecraft.");
    }

    public Class<?> getServerClass() {
        return this.serverClass;
    }

    @Override
    public MCServer getMcServer() {
        return this.mcServer;
    }

    @Override
    public MCVersionMappingRegistry getVersionMappingRegistry() {
        return this.versionMappingRegistry;
    }

    @Override
    public NMSClassResolver getNmsClassResolver() {
        return this.nmsClassResolver;
    }

    @Override
    public OBCClassResolver getObcClassResolver() {
        return this.obcClassResolver;
    }
}

