/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.player;

import com.google.common.collect.Sets;
import info.cho.passwords.fairy.bukkit.events.player.IPlayerEvent;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;

public final class PlayerEventRecognizer {
    private static final Map<Class<? extends Attribute<?>>, Attribute<?>> ATTRIBUTE_INSTANCE = new ConcurrentHashMap();
    private static final Map<Class<?>, Function<Event, Player>> EVENT_PLAYER_METHODS = new ConcurrentHashMap();
    private static final Set<Class<?>> NO_METHODS = Sets.newConcurrentHashSet();

    public static boolean isTypePossible(Class<? extends Event> type) {
        if (PlayerEvent.class.isAssignableFrom(type)) {
            return true;
        }
        if (IPlayerEvent.class.isAssignableFrom(type)) {
            return true;
        }
        if (EntityEvent.class.isAssignableFrom(type)) {
            return true;
        }
        if (EVENT_PLAYER_METHODS.containsKey(type)) {
            return true;
        }
        return PlayerEventRecognizer.searchMethod(type, true) != null;
    }

    @SafeVarargs
    @Nullable
    public static Player tryRecognize(Event event, Class<? extends Attribute<?>> ... attributes) {
        Player player = PlayerEventRecognizer.tryRecognize0(event);
        player = PlayerEventRecognizer.transformEvent(event, player, attributes);
        return player;
    }

    private static Player tryRecognize0(Event event) {
        if (event instanceof PlayerEvent) {
            return ((PlayerEvent)event).getPlayer();
        }
        if (event instanceof IPlayerEvent) {
            return ((IPlayerEvent)event).getPlayer();
        }
        if (event instanceof EntityEvent) {
            Entity entity = ((EntityEvent)event).getEntity();
            if (entity instanceof Player) {
                return (Player)entity;
            }
            return null;
        }
        Class<?> type = event.getClass();
        Function function = EVENT_PLAYER_METHODS.computeIfAbsent(type, ignored -> PlayerEventRecognizer.searchMethod(type, false));
        if (function != null) {
            return (Player)function.apply(event);
        }
        return null;
    }

    private static MethodHandleFunction searchMethod(Class<? extends Event> type, boolean put) {
        if (!NO_METHODS.contains(type)) {
            for (Method method : type.getMethods()) {
                Class<?> returnType;
                if (method.getParameterCount() != 0 || !Player.class.isAssignableFrom(returnType = method.getReturnType()) && !HumanEntity.class.isAssignableFrom(returnType)) continue;
                try {
                    MethodHandleFunction methodHandleFunction = new MethodHandleFunction(method);
                    if (put) {
                        EVENT_PLAYER_METHODS.put(type, methodHandleFunction);
                    }
                    return methodHandleFunction;
                }
                catch (Throwable throwable) {
                    throw new IllegalArgumentException("Something wrong while looking for player", throwable);
                }
            }
            NO_METHODS.add(type);
        }
        return null;
    }

    @SafeVarargs
    private static Player transformEvent(Event event, Player player, Class<? extends Attribute<?>> ... attributes) {
        for (Class<Attribute<?>> clazz : attributes) {
            Attribute<?> attribute = PlayerEventRecognizer.getAttributeInstance(clazz);
            if (!attribute.type().isInstance(event)) continue;
            player = attribute.transform0(event, player);
        }
        return player;
    }

    private static Attribute<?> getAttributeInstance(Class<? extends Attribute<?>> type) {
        return ATTRIBUTE_INSTANCE.computeIfAbsent(type, ignored -> {
            try {
                return (Attribute)type.newInstance();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    private PlayerEventRecognizer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        EVENT_PLAYER_METHODS.put(BlockBreakEvent.class, event -> ((BlockBreakEvent)event).getPlayer());
        EVENT_PLAYER_METHODS.put(BlockPlaceEvent.class, event -> ((BlockPlaceEvent)event).getPlayer());
        EVENT_PLAYER_METHODS.put(FoodLevelChangeEvent.class, event -> (Player)((FoodLevelChangeEvent)event).getEntity());
    }

    private static class MethodHandleFunction
    implements Function<Event, Player> {
        private final Method methodHandle;

        @Override
        public Player apply(Event event) {
            try {
                Object entity = this.methodHandle.invoke((Object)event, new Object[0]);
                if (entity instanceof HumanEntity) {
                    return (Player)entity;
                }
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("Something wrong while looking for player", throwable);
            }
            return null;
        }

        public MethodHandleFunction(Method methodHandle) {
            this.methodHandle = methodHandle;
        }
    }

    public static interface Attribute<T extends Event> {
        public Class<T> type();

        default public Player transform0(Event event, Player player) {
            return this.transform((Event)this.type().cast(event), player);
        }

        public Player transform(T var1, @Nullable Player var2);
    }
}

