/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.reflection.resolver;

import info.cho.passwords.fairy.bukkit.reflection.resolver.MemberResolver;
import info.cho.passwords.fairy.bukkit.reflection.resolver.ResolverQuery;
import info.cho.passwords.fairy.bukkit.reflection.wrapper.ConstructorWrapper;
import info.cho.passwords.fairy.util.AccessUtil;
import info.cho.passwords.fairy.util.Utility;
import java.lang.reflect.Constructor;

public class ConstructorResolver
extends MemberResolver<Constructor> {
    public ConstructorResolver(Class<?> clazz) {
        super(clazz);
    }

    public ConstructorResolver(String className) throws ClassNotFoundException {
        super(className);
    }

    @Override
    public Constructor resolveIndex(int index) throws IndexOutOfBoundsException, ReflectiveOperationException {
        return AccessUtil.setAccessible(this.clazz.getDeclaredConstructors()[index]);
    }

    @Override
    public Constructor resolveIndexSilent(int index) {
        try {
            return this.resolveIndex(index);
        }
        catch (IndexOutOfBoundsException | ReflectiveOperationException exception) {
            return null;
        }
    }

    @Override
    public ConstructorWrapper resolveIndexWrapper(int index) {
        return new ConstructorWrapper(this.resolveIndexSilent(index));
    }

    public ConstructorWrapper resolveWrapper(Class<?>[] ... types) {
        return new ConstructorWrapper(this.resolveSilent(types));
    }

    public Constructor resolveSilent(Class<?>[] ... types) {
        try {
            return this.resolve(types);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Constructor resolve(Class<?>[] ... types) throws NoSuchMethodException {
        ResolverQuery.Builder builder = ResolverQuery.builder();
        for (Class<?>[] type : types) {
            builder.with(type);
        }
        try {
            return (Constructor)super.resolve(builder.build());
        }
        catch (ReflectiveOperationException e) {
            throw (NoSuchMethodException)e;
        }
    }

    public ConstructorWrapper resolveMatches(Class<?>[] ... types) {
        for (Class<?>[] parameters : types) {
            for (Constructor<?> constructor : this.clazz.getDeclaredConstructors()) {
                Class<?>[] parametersTypes = constructor.getParameterTypes();
                if (!ConstructorResolver.isParametersEquals(parametersTypes, parameters)) continue;
                try {
                    return new ConstructorWrapper(AccessUtil.setAccessible(constructor));
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    @Override
    protected Constructor resolveObject(ResolverQuery query) throws ReflectiveOperationException {
        return AccessUtil.setAccessible(this.clazz.getDeclaredConstructor(query.getTypes()));
    }

    public Constructor resolveFirstConstructor() throws ReflectiveOperationException {
        int n = 0;
        Constructor<?>[] constructorArray = this.clazz.getDeclaredConstructors();
        int n2 = constructorArray.length;
        if (n < n2) {
            Constructor<?> constructor = constructorArray[n];
            return AccessUtil.setAccessible(constructor);
        }
        return null;
    }

    public Constructor resolveFirstConstructorSilent() {
        try {
            return this.resolveFirstConstructor();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Constructor resolveLastConstructor() throws ReflectiveOperationException {
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = this.clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        for (int i = 0; i < n; ++i) {
            Constructor<?> constructor1;
            constructor = constructor1 = constructorArray[i];
        }
        if (constructor != null) {
            return AccessUtil.setAccessible(constructor);
        }
        return null;
    }

    public Constructor resolveLastConstructorSilent() {
        try {
            return this.resolveLastConstructor();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected NoSuchMethodException notFoundException(String joinedNames) {
        return new NoSuchMethodException("Could not resolve constructor for " + joinedNames + " in class " + this.clazz);
    }

    static boolean isParametersEquals(Class<?>[] l1, Class<?>[] l2) {
        boolean equal = true;
        if (l1.length != l2.length) {
            return false;
        }
        for (int i = 0; i < l1.length; ++i) {
            if (Utility.wrapPrimitive(l1[i]) == Utility.wrapPrimitive(l2[i])) continue;
            equal = false;
            break;
        }
        return equal;
    }
}

