/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.reflection.resolver;

import info.cho.passwords.fairy.bukkit.reflection.resolver.MemberResolver;
import info.cho.passwords.fairy.bukkit.reflection.resolver.ResolverQuery;
import info.cho.passwords.fairy.bukkit.reflection.wrapper.MethodWrapper;
import info.cho.passwords.fairy.util.AccessUtil;
import java.lang.reflect.Method;

public class MethodResolver
extends MemberResolver<Method> {
    public MethodResolver(Class<?> clazz) {
        super(clazz);
    }

    public MethodResolver(String className) throws ClassNotFoundException {
        super(className);
    }

    public Method resolveSignature(String ... signatures) throws ReflectiveOperationException {
        for (Method method : this.clazz.getDeclaredMethods()) {
            String methodSignature = MethodWrapper.getMethodSignature(method);
            for (String s : signatures) {
                if (!s.equals(methodSignature)) continue;
                return AccessUtil.setAccessible(method);
            }
        }
        return null;
    }

    public Method resolveSignatureSilent(String ... signatures) {
        try {
            return this.resolveSignature(signatures);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    public MethodWrapper resolveSignatureWrapper(String ... signatures) {
        return new MethodWrapper(this.resolveSignatureSilent(signatures));
    }

    public MethodWrapper resolve(int index, Class<?> ... parameters) throws ReflectiveOperationException {
        return new MethodWrapper(this.resolve(new ResolverQuery(index, parameters)));
    }

    public MethodWrapper resolve(Class<?> returnType, int index, Class<?> ... parameters) throws ReflectiveOperationException {
        return new MethodWrapper(this.resolve(new ResolverQuery(returnType, index, parameters)));
    }

    @Override
    public Method resolveIndex(int index) throws IndexOutOfBoundsException, ReflectiveOperationException {
        return AccessUtil.setAccessible(this.clazz.getDeclaredMethods()[index]);
    }

    @Override
    public Method resolveIndexSilent(int index) {
        try {
            return this.resolveIndex(index);
        }
        catch (IndexOutOfBoundsException | ReflectiveOperationException exception) {
            return null;
        }
    }

    @Override
    public MethodWrapper resolveIndexWrapper(int index) {
        return new MethodWrapper(this.resolveIndexSilent(index));
    }

    public MethodWrapper resolveWrapper(String ... names) {
        return new MethodWrapper(this.resolveSilent(names));
    }

    public MethodWrapper resolveWrapper(ResolverQuery ... queries) {
        return new MethodWrapper(this.resolveSilent(queries));
    }

    public Method resolveSilent(String ... names) {
        try {
            return this.resolve(names);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Method resolveSilent(ResolverQuery ... queries) {
        return (Method)super.resolveSilent(queries);
    }

    public Method resolve(String ... names) throws NoSuchMethodException {
        ResolverQuery.Builder builder = ResolverQuery.builder();
        for (String name : names) {
            builder.with(name);
        }
        return this.resolve(builder.build());
    }

    @Override
    public Method resolve(ResolverQuery ... queries) throws NoSuchMethodException {
        try {
            return (Method)super.resolve(queries);
        }
        catch (ReflectiveOperationException e) {
            throw (NoSuchMethodException)e;
        }
    }

    @Override
    protected Method resolveObject(ResolverQuery query) throws ReflectiveOperationException {
        return this.accessorCache.resolveMethod(query);
    }

    @Override
    protected NoSuchMethodException notFoundException(String joinedNames) {
        return new NoSuchMethodException("Could not resolve method for " + joinedNames + " in class " + this.clazz);
    }
}

