/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.reflection.resolver;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;

public class ResolverQuery {
    private String name;
    private int index = -1;
    private Class<?> returnType;
    private Class<?>[] types;
    private boolean supertypes;
    private ModifierOptions modifierOptions;

    public ResolverQuery(Class<?> returnType, String name, int index, boolean supertypes, Class<?> ... types) {
        this.returnType = returnType;
        this.index = index;
        this.name = name;
        this.types = types;
        this.supertypes = supertypes;
    }

    public ResolverQuery(Class<?> returnType, String name, int index, Class<?> ... types) {
        this.returnType = returnType;
        this.index = index;
        this.name = name;
        this.types = types;
    }

    public ResolverQuery(Class<?> returnType, int index, Class<?> ... types) {
        this.returnType = returnType;
        this.index = index;
        this.types = types;
    }

    public ResolverQuery(int index, Class<?> ... types) {
        this.index = index;
        this.types = types;
    }

    public ResolverQuery(Class<?> returnType, int index) {
        this.returnType = returnType;
        this.index = index;
        this.types = new Class[0];
    }

    public ResolverQuery(Class<?> returnType, String name, Class<?> ... types) {
        this.returnType = returnType;
        this.name = name;
        this.types = types;
    }

    public ResolverQuery(String name, Class<?> ... types) {
        this.name = name;
        this.types = types;
    }

    public ResolverQuery(String name) {
        this.name = name;
        this.types = new Class[0];
    }

    public ResolverQuery(Class<?> ... types) {
        this.types = types;
    }

    public ResolverQuery withModifierOptions(ModifierOptions modifierOptions) {
        this.modifierOptions = modifierOptions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolverQuery that = (ResolverQuery)o;
        if (this.index != that.index) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.returnType != null ? !this.returnType.equals(that.returnType) : that.returnType != null) {
            return false;
        }
        if (!Arrays.equals(this.types, that.types)) {
            return false;
        }
        return this.modifierOptions != null ? this.modifierOptions.equals(that.modifierOptions) : that.modifierOptions == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.index;
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.types);
        result = 31 * result + (this.modifierOptions != null ? this.modifierOptions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", ResolverQuery.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("index=" + this.index).add("returnType=" + this.returnType).add("types=" + Arrays.toString(this.types)).add("modifierOptions=" + this.modifierOptions).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Class<?>[] getTypes() {
        return this.types;
    }

    public boolean isSupertypes() {
        return this.supertypes;
    }

    public ModifierOptions getModifierOptions() {
        return this.modifierOptions;
    }

    public ResolverQuery(String name, int index, Class<?> returnType, Class<?>[] types, boolean supertypes, ModifierOptions modifierOptions) {
        this.name = name;
        this.index = index;
        this.returnType = returnType;
        this.types = types;
        this.supertypes = supertypes;
        this.modifierOptions = modifierOptions;
    }

    public static class ModifierOptions {
        private boolean onlyDynamic;
        private boolean onlyStatic;
        private boolean onlyNonFinal;
        private boolean onlyFinal;

        public boolean matches(int modifier) {
            if (this.onlyDynamic ? Modifier.isStatic(modifier) : this.onlyStatic && !Modifier.isStatic(modifier)) {
                return false;
            }
            if (this.onlyNonFinal) {
                return !Modifier.isFinal(modifier);
            }
            if (this.onlyFinal) {
                return Modifier.isFinal(modifier);
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModifierOptions that = (ModifierOptions)o;
            if (this.onlyDynamic != that.onlyDynamic) {
                return false;
            }
            if (this.onlyStatic != that.onlyStatic) {
                return false;
            }
            if (this.onlyNonFinal != that.onlyNonFinal) {
                return false;
            }
            return this.onlyFinal == that.onlyFinal;
        }

        public int hashCode() {
            int result = this.onlyDynamic ? 1 : 0;
            result = 31 * result + (this.onlyStatic ? 1 : 0);
            result = 31 * result + (this.onlyNonFinal ? 1 : 0);
            result = 31 * result + (this.onlyFinal ? 1 : 0);
            return result;
        }

        ModifierOptions(boolean onlyDynamic, boolean onlyStatic, boolean onlyNonFinal, boolean onlyFinal) {
            this.onlyDynamic = onlyDynamic;
            this.onlyStatic = onlyStatic;
            this.onlyNonFinal = onlyNonFinal;
            this.onlyFinal = onlyFinal;
        }

        public static ModifierOptionsBuilder builder() {
            return new ModifierOptionsBuilder();
        }

        public boolean isOnlyDynamic() {
            return this.onlyDynamic;
        }

        public boolean isOnlyStatic() {
            return this.onlyStatic;
        }

        public boolean isOnlyNonFinal() {
            return this.onlyNonFinal;
        }

        public boolean isOnlyFinal() {
            return this.onlyFinal;
        }

        public static class ModifierOptionsBuilder {
            private boolean onlyDynamic;
            private boolean onlyStatic;
            private boolean onlyNonFinal;
            private boolean onlyFinal;

            ModifierOptionsBuilder() {
            }

            public ModifierOptionsBuilder onlyDynamic(boolean onlyDynamic) {
                this.onlyDynamic = onlyDynamic;
                return this;
            }

            public ModifierOptionsBuilder onlyStatic(boolean onlyStatic) {
                this.onlyStatic = onlyStatic;
                return this;
            }

            public ModifierOptionsBuilder onlyNonFinal(boolean onlyNonFinal) {
                this.onlyNonFinal = onlyNonFinal;
                return this;
            }

            public ModifierOptionsBuilder onlyFinal(boolean onlyFinal) {
                this.onlyFinal = onlyFinal;
                return this;
            }

            public ModifierOptions build() {
                return new ModifierOptions(this.onlyDynamic, this.onlyStatic, this.onlyNonFinal, this.onlyFinal);
            }

            public String toString() {
                return "ResolverQuery.ModifierOptions.ModifierOptionsBuilder(onlyDynamic=" + this.onlyDynamic + ", onlyStatic=" + this.onlyStatic + ", onlyNonFinal=" + this.onlyNonFinal + ", onlyFinal=" + this.onlyFinal + ")";
            }
        }
    }

    public static class Builder {
        private final List<ResolverQuery> queryList = new ArrayList<ResolverQuery>();

        private Builder() {
        }

        public Builder with(Class<?> returnType, String name, int index, boolean supertypes, Class<?>[] types) {
            this.queryList.add(new ResolverQuery(returnType, name, index, supertypes, types));
            return this;
        }

        public Builder with(Class<?> returnType, String name, int index, Class<?>[] types) {
            this.queryList.add(new ResolverQuery(returnType, name, index, types));
            return this;
        }

        public Builder with(Class<?> returnType, int index, Class<?>[] types) {
            this.queryList.add(new ResolverQuery(returnType, index, types));
            return this;
        }

        public Builder with(int index, Class<?>[] types) {
            this.queryList.add(new ResolverQuery(index, types));
            return this;
        }

        public Builder with(Class<?> returnType, int index) {
            this.queryList.add(new ResolverQuery(returnType, index));
            return this;
        }

        public Builder withSupertypes(Class<?> returnType, int index) {
            this.queryList.add(new ResolverQuery(returnType, null, index, true, new Class[0]));
            return this;
        }

        public Builder with(Class<?> returnType, String name, Class<?>[] types) {
            this.queryList.add(new ResolverQuery(returnType, name, types));
            return this;
        }

        public Builder with(String name, Class<?>[] types) {
            this.queryList.add(new ResolverQuery(name, types));
            return this;
        }

        public Builder with(String name) {
            this.queryList.add(new ResolverQuery(name));
            return this;
        }

        public Builder with(Class<?>[] types) {
            this.queryList.add(new ResolverQuery(types));
            return this;
        }

        public ResolverQuery[] build() {
            return this.queryList.toArray(new ResolverQuery[this.queryList.size()]);
        }
    }

    public static class ResolverQueryBuilder {
        private String name;
        private int index;
        private Class<?> returnType;
        private Class<?>[] types;
        private boolean supertypes;
        private ModifierOptions modifierOptions;

        ResolverQueryBuilder() {
        }

        public ResolverQueryBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ResolverQueryBuilder index(int index) {
            this.index = index;
            return this;
        }

        public ResolverQueryBuilder returnType(Class<?> returnType) {
            this.returnType = returnType;
            return this;
        }

        public ResolverQueryBuilder types(Class<?>[] types) {
            this.types = types;
            return this;
        }

        public ResolverQueryBuilder supertypes(boolean supertypes) {
            this.supertypes = supertypes;
            return this;
        }

        public ResolverQueryBuilder modifierOptions(ModifierOptions modifierOptions) {
            this.modifierOptions = modifierOptions;
            return this;
        }

        public ResolverQuery build() {
            return new ResolverQuery(this.name, this.index, this.returnType, this.types, this.supertypes, this.modifierOptions);
        }

        public String toString() {
            return "ResolverQuery.ResolverQueryBuilder(name=" + this.name + ", index=" + this.index + ", returnType=" + this.returnType + ", types=" + Arrays.deepToString(this.types) + ", supertypes=" + this.supertypes + ", modifierOptions=" + this.modifierOptions + ")";
        }
    }
}

