/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.scheduler.folia;

import info.cho.passwords.fairy.bukkit.scheduler.folia.FoliaAbstractScheduler;
import info.cho.passwords.fairy.bukkit.scheduler.folia.FoliaRepeatedScheduledTask;
import info.cho.passwords.fairy.bukkit.scheduler.folia.wrapper.WrapperScheduledTask;
import info.cho.passwords.fairy.mc.scheduler.MCTickBasedScheduler;
import info.cho.passwords.fairy.scheduler.repeat.RepeatPredicate;
import info.cho.passwords.fairy.scheduler.response.TaskResponse;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class FoliaGlobalRegionScheduler
extends FoliaAbstractScheduler
implements MCTickBasedScheduler {
    private final Plugin bukkitPlugin;
    private final GlobalRegionScheduler scheduler;
    private final Method isGlobalTickThread;

    public FoliaGlobalRegionScheduler(Plugin bukkitPlugin) {
        this.bukkitPlugin = bukkitPlugin;
        this.scheduler = Bukkit.getGlobalRegionScheduler();
        try {
            this.isGlobalTickThread = Bukkit.class.getMethod("isGlobalTickThread", new Class[0]);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot find isGlobalTickThread method in Bukkit", e);
        }
    }

    @Override
    public boolean isCurrentThread() {
        try {
            return (Boolean)this.isGlobalTickThread.invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot invoke isGlobalTickThread method in Bukkit", e);
        }
    }

    @Override
    public <R> info.cho.passwords.fairy.scheduler.ScheduledTask<R> schedule(Callable<R> callable) {
        return this.doSchedule(callable, task -> this.scheduler.run(this.bukkitPlugin, task));
    }

    @Override
    public <R> info.cho.passwords.fairy.scheduler.ScheduledTask<R> schedule(Callable<R> callable, long delayTicks) {
        return this.doSchedule(callable, task -> this.scheduler.runDelayed(this.bukkitPlugin, task, delayTicks));
    }

    @Override
    public <R> info.cho.passwords.fairy.scheduler.ScheduledTask<R> scheduleAtFixedRate(Callable<TaskResponse<R>> callback, long delayTicks, long intervalTicks, RepeatPredicate<R> predicate) {
        FoliaRepeatedScheduledTask<R> task = new FoliaRepeatedScheduledTask<R>(callback, predicate);
        ScheduledTask rawScheduledTask = this.scheduler.runAtFixedRate(this.bukkitPlugin, task, delayTicks, intervalTicks);
        task.setScheduledTask(WrapperScheduledTask.of(rawScheduledTask));
        return task;
    }
}

