/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.scheduler.folia;

import info.cho.passwords.fairy.bukkit.scheduler.folia.FoliaAbstractScheduler;
import info.cho.passwords.fairy.bukkit.scheduler.folia.FoliaRepeatedScheduledTask;
import info.cho.passwords.fairy.bukkit.scheduler.folia.wrapper.WrapperScheduledTask;
import info.cho.passwords.fairy.mc.scheduler.MCTickBasedScheduler;
import info.cho.passwords.fairy.scheduler.repeat.RepeatPredicate;
import info.cho.passwords.fairy.scheduler.response.TaskResponse;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class FoliaRegionScheduler
extends FoliaAbstractScheduler
implements MCTickBasedScheduler {
    private final Plugin bukkitPlugin;
    private final World world;
    private final int x;
    private final int z;
    private final RegionScheduler scheduler;

    public FoliaRegionScheduler(Plugin bukkitPlugin, Location location) {
        this.bukkitPlugin = bukkitPlugin;
        this.world = location.getWorld();
        this.x = location.getBlockX() >> 4;
        this.z = location.getBlockZ() >> 4;
        this.scheduler = Bukkit.getRegionScheduler();
    }

    public FoliaRegionScheduler(Plugin bukkitPlugin, World world, int x, int z) {
        this.bukkitPlugin = bukkitPlugin;
        this.world = world;
        this.x = x;
        this.z = z;
        this.scheduler = Bukkit.getRegionScheduler();
    }

    @Override
    public boolean isCurrentThread() {
        try {
            return Bukkit.isOwnedByCurrentRegion((World)this.world, (int)this.x, (int)this.z);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot invoke isOwnedByCurrentRegion method in Bukkit", e);
        }
    }

    @Override
    public <R> info.cho.passwords.fairy.scheduler.ScheduledTask<R> schedule(Callable<R> callable) {
        return this.doSchedule(callable, task -> this.scheduler.run(this.bukkitPlugin, this.world, this.x, this.z, task));
    }

    @Override
    public <R> info.cho.passwords.fairy.scheduler.ScheduledTask<R> schedule(Callable<R> callable, long delayTicks) {
        return this.doSchedule(callable, task -> this.scheduler.runDelayed(this.bukkitPlugin, this.world, this.x, this.z, task, delayTicks));
    }

    @Override
    public <R> info.cho.passwords.fairy.scheduler.ScheduledTask<R> scheduleAtFixedRate(Callable<TaskResponse<R>> callback, long delayTicks, long intervalTicks, RepeatPredicate<R> predicate) {
        FoliaRepeatedScheduledTask<R> task = new FoliaRepeatedScheduledTask<R>(callback, predicate);
        ScheduledTask rawScheduledTask = this.scheduler.runAtFixedRate(this.bukkitPlugin, this.world, this.x, this.z, task, delayTicks, intervalTicks);
        task.setScheduledTask(WrapperScheduledTask.of(rawScheduledTask));
        return task;
    }
}

