/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.scheduler.folia;

import info.cho.passwords.fairy.bukkit.scheduler.folia.FoliaAsyncScheduler;
import info.cho.passwords.fairy.bukkit.scheduler.folia.FoliaEntityScheduler;
import info.cho.passwords.fairy.bukkit.scheduler.folia.FoliaGlobalRegionScheduler;
import info.cho.passwords.fairy.bukkit.scheduler.folia.FoliaRegionScheduler;
import info.cho.passwords.fairy.bukkit.util.BukkitPos;
import info.cho.passwords.fairy.mc.MCWorld;
import info.cho.passwords.fairy.mc.scheduler.MCScheduler;
import info.cho.passwords.fairy.mc.scheduler.MCSchedulerProvider;
import info.cho.passwords.fairy.mc.util.Position;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class FoliaSchedulerProvider
implements MCSchedulerProvider {
    private final Plugin plugin;

    @Override
    public MCScheduler getGlobalScheduler() {
        return new FoliaGlobalRegionScheduler(this.plugin);
    }

    @Override
    public MCScheduler getAsyncScheduler() {
        return new FoliaAsyncScheduler(this.plugin);
    }

    @Override
    public MCScheduler getEntityScheduler(Object entity) {
        if (entity instanceof Entity) {
            return new FoliaEntityScheduler((Entity)entity, this.plugin);
        }
        throw new IllegalArgumentException("entity must be an instance of org.bukkit.entity.Entity");
    }

    @Override
    public MCScheduler getLocationScheduler(Position position) {
        return new FoliaRegionScheduler(this.plugin, BukkitPos.toBukkitLocation(position));
    }

    @Override
    public MCScheduler getChunkScheduler(MCWorld world, int chunkX, int chunkZ) {
        return new FoliaRegionScheduler(this.plugin, world.as(World.class), chunkX, chunkZ);
    }

    public FoliaSchedulerProvider(Plugin plugin) {
        this.plugin = plugin;
    }
}

