/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.util;

import java.lang.reflect.Method;
import java.util.function.Function;
import org.bukkit.entity.Player;

public final class PlayerLocaleUtil {
    private static final Function<Player, String> GET_LOCALE_FUNCTION;

    private PlayerLocaleUtil() {
    }

    public static String getLocale(Player player) {
        return GET_LOCALE_FUNCTION.apply(player);
    }

    static {
        Function<Player, String> function;
        try {
            Method modernMethod = Player.class.getDeclaredMethod("getLocale", new Class[0]);
            function = player -> {
                try {
                    return (String)modernMethod.invoke(player, new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (ReflectiveOperationException ex) {
            try {
                Method legacyMethod = Player.Spigot.class.getMethod("getLocale", new Class[0]);
                function = player -> {
                    try {
                        return (String)legacyMethod.invoke((Object)player.spigot(), new Object[0]);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (ReflectiveOperationException e) {
                function = player -> null;
            }
        }
        GET_LOCALE_FUNCTION = function;
    }
}

