/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.util;

import info.cho.passwords.fairy.bukkit.events.player.PlayerClearEvent;
import info.cho.passwords.fairy.mc.scheduler.MCSchedulers;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;

public final class Players {
    public static UUID tryGetUniqueId(@NotNull Object player) {
        if (player instanceof UUID) {
            return (UUID)player;
        }
        if (player instanceof Player) {
            return ((Player)player).getUniqueId();
        }
        throw new ClassCastException(player.getClass().getName() + " is not a Player");
    }

    public static List<Player> transformUuids(Collection<UUID> uuids) {
        return Players.transformUuids(uuids.stream());
    }

    public static List<Player> transformUuids(UUID ... uuids) {
        return Players.transformUuids(Stream.of(uuids));
    }

    public static List<Player> transformUuids(Stream<UUID> uuids) {
        return Players.streamUuids(uuids).collect(Collectors.toList());
    }

    public static Stream<Player> streamUuids(Collection<UUID> uuids) {
        return Players.streamUuids(uuids.stream());
    }

    public static Stream<Player> streamUuids(UUID ... uuids) {
        return Players.streamUuids(Stream.of(uuids));
    }

    public static Stream<Player> streamUuids(Stream<UUID> uuids) {
        return uuids.map(Bukkit::getPlayer).filter(Objects::nonNull);
    }

    public static void clear(Player player) {
        player.setHealth(player.getMaxHealth());
        player.setFoodLevel(20);
        player.setExp(0.0f);
        player.setTotalExperience(0);
        player.setLevel(0);
        player.setFireTicks(0);
        player.setFallDistance(0.0f);
        player.getInventory().clear();
        player.getInventory().setArmorContents(null);
        player.updateInventory();
        player.setGameMode(GameMode.SURVIVAL);
        player.getActivePotionEffects().stream().map(PotionEffect::getType).forEach(arg_0 -> ((Player)player).removePotionEffect(arg_0));
        new PlayerClearEvent(player).call();
    }

    public static CompletableFuture<PlayerInventory> updateInventoryLater(Player player) {
        return MCSchedulers.getEntityScheduler(player).schedule(() -> {
            player.updateInventory();
            return player.getInventory();
        }, 1L).getFuture();
    }

    private Players() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

