/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.util.items;

import info.cho.passwords.fairy.libs.xseries.XMaterial;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public final class ItemUtil {
    public static String serializeItemStack(@Nullable ItemStack item) {
        Map enchantments;
        StringBuilder builder = new StringBuilder();
        if (item == null) {
            return "null";
        }
        String type = XMaterial.matchXMaterial(item).name();
        builder.append("t@").append(type);
        if (item.getDurability() != 0) {
            String isDurability = String.valueOf(item.getDurability());
            builder.append(":d@").append(isDurability);
        }
        if (item.getAmount() != 1) {
            String isAmount = String.valueOf(item.getAmount());
            builder.append(":a@").append(isAmount);
        }
        if ((enchantments = item.getEnchantments()).size() > 0) {
            for (Map.Entry enchantment : enchantments.entrySet()) {
                builder.append(":e@").append(((Enchantment)enchantment.getKey()).getName()).append("@").append(enchantment.getValue());
            }
        }
        if (item.hasItemMeta()) {
            ItemMeta itemMeta = item.getItemMeta();
            if (itemMeta instanceof EnchantmentStorageMeta) {
                for (Map.Entry enchantment : ((EnchantmentStorageMeta)itemMeta).getStoredEnchants().entrySet()) {
                    builder.append(":e@").append(((Enchantment)enchantment.getKey()).getName()).append("@").append(enchantment.getValue());
                }
            }
            if (itemMeta.hasDisplayName()) {
                builder.append(":dn@").append(itemMeta.getDisplayName());
            }
            if (itemMeta.hasLore()) {
                builder.append(":l@").append(itemMeta.getLore());
            }
        }
        return builder.toString();
    }

    public static ItemStack deserializeItemStack(String in) {
        try {
            String[] split;
            ItemStack item = null;
            ItemMeta meta = null;
            boolean applyMeta = false;
            if (in.equals("null")) {
                return XMaterial.AIR.parseItem();
            }
            block18: for (String itemInfo : split = in.split(":")) {
                String s2;
                String[] itemAttribute = itemInfo.split("@");
                switch (s2 = itemAttribute[0]) {
                    case "t": {
                        XMaterial material = XMaterial.matchXMaterial(itemAttribute[1]).orElse(null);
                        if (material == null) {
                            throw new IllegalArgumentException("Invalid material: " + itemAttribute[1]);
                        }
                        item = material.parseItem();
                        meta = item.getItemMeta();
                        continue block18;
                    }
                    case "d": {
                        if (item == null) continue block18;
                        item.setDurability(Short.parseShort(itemAttribute[1]));
                        continue block18;
                    }
                    case "a": {
                        if (item == null) continue block18;
                        item.setAmount(Integer.parseInt(itemAttribute[1]));
                        continue block18;
                    }
                    case "e": {
                        if (item == null) continue block18;
                        if (meta instanceof EnchantmentStorageMeta) {
                            applyMeta = true;
                            ((EnchantmentStorageMeta)meta).addStoredEnchant(Enchantment.getByName((String)itemAttribute[1]), Integer.parseInt(itemAttribute[2]), true);
                            continue block18;
                        }
                        item.addUnsafeEnchantment(Enchantment.getByName((String)itemAttribute[1]), Integer.parseInt(itemAttribute[2]));
                        continue block18;
                    }
                    case "dn": {
                        if (meta == null) continue block18;
                        meta.setDisplayName(itemAttribute[1]);
                        continue block18;
                    }
                    case "l": {
                        itemAttribute[1] = itemAttribute[1].replace("[", "");
                        itemAttribute[1] = itemAttribute[1].replace("]", "");
                        List<String> lore = Arrays.asList(itemAttribute[1].split(","));
                        for (int x = 0; x < lore.size(); ++x) {
                            String s = lore.get(x);
                            if (s == null || s.toCharArray().length == 0) continue;
                            if (s.charAt(0) == ' ') {
                                s = s.replaceFirst(" ", "");
                            }
                            lore.set(x, s);
                        }
                        if (meta == null) continue block18;
                        meta.setLore(lore);
                        continue block18;
                    }
                }
            }
            if (meta != null && (applyMeta || meta.hasDisplayName() || meta.hasLore())) {
                item.setItemMeta(meta);
            }
            return item;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("An error thrown while deserializing item " + in, throwable);
        }
    }

    private ItemUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

