/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.util.items.behaviour;

import info.cho.passwords.fairy.bukkit.listener.ListenerRegistry;
import info.cho.passwords.fairy.bukkit.util.items.behaviour.ItemBehaviourListener;
import lombok.NonNull;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class ItemBehaviourInteract
extends ItemBehaviourListener {
    private final Callback callback;
    private final Action[] actions;

    public ItemBehaviourInteract(ListenerRegistry listenerRegistry, @NonNull Callback callback, Action ... actions) {
        super(listenerRegistry);
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        this.callback = callback;
        this.actions = actions;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Action action = event.getAction();
        ItemStack itemStack = event.getItem();
        if (!this.isActionMatches(action)) {
            return;
        }
        if (!this.matches(player, itemStack)) {
            return;
        }
        this.callback.call(player, itemStack, action, event);
    }

    public boolean isActionMatches(Action action) {
        if (this.actions.length == 0) {
            return true;
        }
        for (Action allowed : this.actions) {
            if (allowed != action) continue;
            return true;
        }
        return false;
    }

    public static interface Callback {
        public void call(Player var1, ItemStack var2, Action var3, PlayerInteractEvent var4);
    }
}

