/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.util.items.impl;

import info.cho.passwords.fairy.bukkit.util.items.FairyItem;
import info.cho.passwords.fairy.bukkit.util.items.FairyItemRegistry;
import info.cho.passwords.fairy.bukkit.util.items.ItemBuilder;
import info.cho.passwords.fairy.bukkit.util.items.behaviour.ItemBehaviour;
import info.cho.passwords.fairy.data.MetaStorage;
import info.cho.passwords.fairy.mc.MCPlayer;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class FairyItemImpl
implements FairyItem {
    private final FairyItemRegistry itemRegistry;
    private final String name;
    private final MetaStorage metaStorage;
    private final List<ItemBehaviour> behaviours;
    private final Function<MCPlayer, ItemBuilder> itemProvider;
    private boolean closed;

    public FairyItemImpl(@NonNull FairyItemRegistry itemRegistry, @NonNull String name, @NonNull MetaStorage metaStorage, @NonNull List<ItemBehaviour> behaviours, @NonNull Function<MCPlayer, ItemBuilder> itemProvider) {
        if (itemRegistry == null) {
            throw new NullPointerException("itemRegistry is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (metaStorage == null) {
            throw new NullPointerException("metaStorage is marked non-null but is null");
        }
        if (behaviours == null) {
            throw new NullPointerException("behaviours is marked non-null but is null");
        }
        if (itemProvider == null) {
            throw new NullPointerException("itemProvider is marked non-null but is null");
        }
        this.itemRegistry = itemRegistry;
        this.name = name;
        this.metaStorage = metaStorage;
        this.behaviours = behaviours;
        this.itemProvider = itemProvider;
        this.closed = true;
    }

    @Override
    @NotNull
    public Iterable<ItemBehaviour> getBehaviours() {
        return Collections.unmodifiableList(this.behaviours);
    }

    @Override
    @NotNull
    public ItemBuilder provide(@NotNull MCPlayer mcPlayer) {
        return this.itemProvider.apply(mcPlayer).clone().transformItemStack(itemStack -> this.itemRegistry.set((ItemStack)itemStack, this));
    }

    @Override
    public void init() {
        this.behaviours.forEach(behaviour -> behaviour.init(this));
        this.closed = false;
    }

    @Override
    public void close() {
        this.behaviours.forEach(ItemBehaviour::unregister);
        this.closed = true;
    }

    @Override
    public boolean isSimilar(@NotNull ItemStack itemStack) {
        return this.itemRegistry.get(itemStack) == this;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public FairyItemRegistry getItemRegistry() {
        return this.itemRegistry;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MetaStorage getMetaStorage() {
        return this.metaStorage;
    }

    public Function<MCPlayer, ItemBuilder> getItemProvider() {
        return this.itemProvider;
    }
}

