/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.util.items.impl;

import info.cho.passwords.fairy.bukkit.nbt.NBTKey;
import info.cho.passwords.fairy.bukkit.nbt.NBTModifier;
import info.cho.passwords.fairy.bukkit.util.items.ItemBuilder;
import info.cho.passwords.fairy.bukkit.util.items.util.ItemBuilderUtil;
import info.cho.passwords.fairy.libs.kyori.adventure.text.Component;
import info.cho.passwords.fairy.libs.xseries.XEnchantment;
import info.cho.passwords.fairy.libs.xseries.XMaterial;
import info.cho.passwords.fairy.libs.xseries.profiles.builder.XSkull;
import info.cho.passwords.fairy.libs.xseries.profiles.objects.Profileable;
import info.cho.passwords.fairy.util.CC;
import info.cho.passwords.fairy.util.ConditionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilderImpl
implements ItemBuilder {
    private ItemStack itemStack;

    public ItemBuilderImpl(XMaterial mat) {
        this.itemStack = mat.parseItem();
    }

    public ItemBuilderImpl(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public ItemBuilderImpl amount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    @Override
    public ItemBuilder name(Locale locale, Component name) {
        return this.editMeta(meta -> ItemBuilderUtil.setDisplayName(meta, locale, name));
    }

    @Override
    public ItemBuilder lores(Locale locale, Iterable<Component> lores) {
        return this.editMeta(meta -> {
            List<Component> loreList = ItemBuilderUtil.getLore(meta);
            if (loreList == null) {
                loreList = new ArrayList<Component>();
            }
            for (Component s : lores) {
                loreList.add(s);
            }
            ItemBuilderUtil.setLore(meta, locale, loreList);
        });
    }

    @Override
    public ItemBuilder lores(Locale locale, Component ... lores) {
        return this.lores(locale, Arrays.asList(lores));
    }

    @Override
    public ItemBuilderImpl name(String name) {
        return this.editMeta(meta -> meta.setDisplayName(CC.translate(name)));
    }

    @Override
    public ItemBuilderImpl lore(Iterable<String> lore) {
        return this.editMeta(meta -> {
            ArrayList<String> loreList = meta.getLore();
            if (loreList == null) {
                loreList = new ArrayList<String>();
            }
            for (String s : lore) {
                loreList.add(CC.translate(s));
            }
            meta.setLore(loreList);
        });
    }

    @Override
    public ItemBuilderImpl lore(String ... lore) {
        return this.lore(Arrays.asList(lore));
    }

    @Override
    public ItemBuilderImpl unbreakable(boolean unbreakable) {
        return this.editMeta(meta -> meta.setUnbreakable(unbreakable));
    }

    @Override
    public ItemBuilderImpl durability(int durability) {
        this.itemStack.setDurability((short)(-(durability - this.itemStack.getType().getMaxDurability())));
        return this;
    }

    @Override
    public ItemBuilderImpl data(int data) {
        this.itemStack.setDurability((short)data);
        return this;
    }

    @Override
    public ItemBuilderImpl enchantment(XEnchantment enchantment, int level) {
        Enchantment enchant = enchantment.getEnchant();
        ConditionUtils.notNull(enchant, enchantment.name() + " doesn't seems to be supported in current version.");
        this.itemStack.addUnsafeEnchantment(enchant, level);
        return this;
    }

    @Override
    public ItemBuilderImpl enchantment(XEnchantment enchantment) {
        Enchantment enchant = enchantment.getEnchant();
        ConditionUtils.notNull(enchant, enchantment.name() + " doesn't seems to be supported in current version.");
        this.itemStack.addUnsafeEnchantment(enchant, 1);
        return this;
    }

    @Override
    public ItemBuilderImpl type(XMaterial material) {
        Material bukkitMaterial = material.parseMaterial();
        ConditionUtils.notNull(bukkitMaterial, material.name() + " doesn't seems to be supported in current version.");
        this.itemStack.setType(bukkitMaterial);
        return this;
    }

    @Override
    public ItemBuilderImpl clearLore() {
        return this.editMeta(meta -> meta.setLore(Collections.emptyList()));
    }

    @Override
    public ItemBuilderImpl clearEnchantments() {
        for (Enchantment e : this.itemStack.getEnchantments().keySet()) {
            this.itemStack.removeEnchantment(e);
        }
        return this;
    }

    @Override
    public ItemBuilderImpl color(Color color) {
        if (this.itemStack.getType() == Material.LEATHER_BOOTS || this.itemStack.getType() == Material.LEATHER_CHESTPLATE || this.itemStack.getType() == Material.LEATHER_HELMET || this.itemStack.getType() == Material.LEATHER_LEGGINGS) {
            return this.editMeta(LeatherArmorMeta.class, meta -> meta.setColor(color));
        }
        throw new IllegalArgumentException("color() only applicable for leather armor!");
    }

    @Override
    public ItemBuilderImpl skull(String owner) {
        if (XMaterial.PLAYER_HEAD.isSimilar(this.itemStack)) {
            return this.editMeta(itemMeta -> XSkull.of(itemMeta).profile(Profileable.username(owner)).apply());
        }
        throw new IllegalArgumentException("skull() only applicable for human skull item!");
    }

    @Override
    public ItemBuilderImpl skull(Player owner) {
        if (XMaterial.PLAYER_HEAD.isSimilar(this.itemStack)) {
            return this.editMeta(SkullMeta.class, itemMeta -> ItemBuilderUtil.setSkullWithPlayer(itemMeta, owner));
        }
        throw new IllegalArgumentException("skull() only applicable for human skull item!");
    }

    @Override
    public ItemBuilderImpl shiny() {
        return this.editMeta(meta -> {
            meta.addEnchant(Enchantment.UNBREAKING, 1, false);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        });
    }

    @Override
    @Deprecated
    public ItemBuilderImpl tag(Object value, String ... key) {
        return this.tag(NBTKey.create(key), value);
    }

    @Override
    public ItemBuilderImpl tag(NBTKey key, Object value) {
        this.itemStack = NBTModifier.get().setTag(this.itemStack, key, value);
        return this;
    }

    @Override
    public ItemBuilderImpl itemFlag(ItemFlag itemFlag) {
        return this.editMeta(meta -> meta.addItemFlags(new ItemFlag[]{itemFlag}));
    }

    @Override
    public ItemBuilderImpl removeItemFlag(ItemFlag itemFlag) {
        return this.editMeta(meta -> {
            if (meta.hasItemFlag(itemFlag)) {
                meta.removeItemFlags(new ItemFlag[]{itemFlag});
            }
        });
    }

    @Override
    public ItemBuilderImpl editMeta(Consumer<ItemMeta> consumer) {
        ItemMeta meta = this.itemStack.getItemMeta();
        ConditionUtils.notNull(meta, "ItemMeta is null!");
        try {
            consumer.accept(meta);
        }
        finally {
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ItemMeta> ItemBuilderImpl editMeta(Class<T> metaClass, Consumer<T> consumer) {
        ItemMeta meta = this.itemStack.getItemMeta();
        ConditionUtils.notNull(meta, "ItemMeta is null!");
        ConditionUtils.is(metaClass.isInstance(meta), "ItemMeta is not instance of " + metaClass.getName());
        try {
            consumer.accept((ItemMeta)metaClass.cast(meta));
        }
        finally {
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    @Override
    public ItemBuilderImpl editItemStack(Consumer<ItemStack> consumer) {
        consumer.accept(this.itemStack);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemBuilderImpl transformMeta(Function<ItemMeta, ItemMeta> function) {
        ItemMeta meta = this.itemStack.getItemMeta();
        ConditionUtils.notNull(meta, "ItemMeta is null!");
        ItemMeta result = null;
        try {
            result = function.apply(meta);
        }
        finally {
            if (result != null) {
                this.itemStack.setItemMeta(result);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ItemMeta> ItemBuilderImpl transformMeta(Class<T> metaClass, Function<T, T> function) {
        ItemMeta meta = this.itemStack.getItemMeta();
        ConditionUtils.notNull(meta, "ItemMeta is null!");
        ConditionUtils.is(metaClass.isInstance(meta), "ItemMeta is not instance of " + metaClass.getName());
        ItemMeta result = null;
        try {
            result = (ItemMeta)function.apply((ItemMeta)metaClass.cast(meta));
        }
        finally {
            if (result != null) {
                this.itemStack.setItemMeta(result);
            }
        }
        return this;
    }

    @Override
    public ItemBuilderImpl transformItemStack(Function<ItemStack, ItemStack> function) {
        this.itemStack = function.apply(this.itemStack);
        return this;
    }

    @Override
    public ItemBuilderImpl clone() {
        return new ItemBuilderImpl(this.itemStack.clone());
    }

    @Override
    public ItemStack build() {
        return this.itemStack;
    }

    @Override
    public Material getType() {
        return this.itemStack.getType();
    }
}

