/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.util.items.util;

import com.google.common.collect.ImmutableList;
import info.cho.passwords.fairy.bukkit.nms.BukkitNMSManager;
import info.cho.passwords.fairy.bukkit.nms.BukkitNMSManagerImpl;
import info.cho.passwords.fairy.bukkit.reflection.MinecraftReflection;
import info.cho.passwords.fairy.bukkit.reflection.resolver.MethodResolver;
import info.cho.passwords.fairy.bukkit.reflection.wrapper.MethodWrapper;
import info.cho.passwords.fairy.bukkit.util.LegacyAdventureUtil;
import info.cho.passwords.fairy.container.Containers;
import info.cho.passwords.fairy.libs.kyori.adventure.text.Component;
import info.cho.passwords.fairy.libs.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import info.cho.passwords.fairy.mc.MCAdventure;
import info.cho.passwords.fairy.util.AccessUtil;
import info.cho.passwords.fairy.util.exceptionally.SneakyThrowUtil;
import info.cho.passwords.fairy.util.exceptionally.ThrowingRunnable;
import info.cho.passwords.fairy.util.filter.FilterUnit;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ItemBuilderUtil {
    private static Field GAME_PROFILE_FIELD;
    private static MethodWrapper<?> GET_PROFILE_ENTITY_HUMAN_METHOD;
    private static final BiConsumer<SkullMeta, Player> SET_SKULL_WITH_PLAYER;
    private static final TriConsumer<ItemMeta, Locale, Component> SET_DISPLAY_NAME;
    private static final Function<ItemMeta, List<Component>> GET_LORE;
    private static final TriConsumer<ItemMeta, Locale, List<Component>> SET_LORE;

    public static void setSkullWithPlayer(SkullMeta skullMeta, Player player) {
        SET_SKULL_WITH_PLAYER.accept(skullMeta, player);
    }

    public static void setDisplayName(ItemMeta itemMeta, Locale locale, Component component) {
        SET_DISPLAY_NAME.accept(itemMeta, locale, component);
    }

    @Nullable
    public static List<Component> getLore(ItemMeta itemMeta) {
        return GET_LORE.apply(itemMeta);
    }

    public static void setLore(ItemMeta itemMeta, Locale locale, Iterable<Component> components) {
        SET_LORE.accept(itemMeta, locale, (List<Component>)ImmutableList.copyOf(components));
    }

    private ItemBuilderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        SET_SKULL_WITH_PLAYER = FilterUnit.create().add(FilterUnit.Item.create((skullMeta, player) -> skullMeta.setOwningPlayer((OfflinePlayer)player)).predicate(FilterUnit.test(t -> SkullMeta.class.getDeclaredMethod("setOwningPlayer", OfflinePlayer.class), NoSuchMethodException.class))).add((skullMeta, player) -> {
            if (GAME_PROFILE_FIELD == null) {
                ThrowingRunnable.sneaky(() -> {
                    BukkitNMSManager bukkitNMSManager = Containers.get(BukkitNMSManagerImpl.class);
                    Class entityHumanClass = bukkitNMSManager.getNmsClassResolver().resolve("world.entity.player.EntityHuman", "EntityHuman");
                    Class craftMetaSkullClass = bukkitNMSManager.getObcClassResolver().resolve("inventory.CraftMetaSkull");
                    Field field = craftMetaSkullClass.getDeclaredField("profile");
                    AccessUtil.setAccessible(field);
                    GAME_PROFILE_FIELD = field;
                    GET_PROFILE_ENTITY_HUMAN_METHOD = new MethodResolver(entityHumanClass).resolve(MinecraftReflection.GAME_PROFILE_TYPE, 0, new Class[0]);
                }).run();
            }
            Object handle = MinecraftReflection.getHandleSilent(player);
            Object gameProfile = GET_PROFILE_ENTITY_HUMAN_METHOD.invokeSilent(handle, new Object[0]);
            try {
                GAME_PROFILE_FIELD.set(skullMeta, gameProfile);
            }
            catch (IllegalAccessException e) {
                SneakyThrowUtil.sneakyThrow(e);
            }
        }).find().orElseThrow(() -> new IllegalStateException("No valid set skull with player can be found."));
        SET_DISPLAY_NAME = FilterUnit.create().add(FilterUnit.Item.create((itemMeta, locale, component) -> {
            BungeeComponentSerializer serializer = BungeeComponentSerializer.get();
            @NotNull BaseComponent[] baseComponents = serializer.serialize((Component)component);
            itemMeta.setDisplayNameComponent(baseComponents);
        }).predicate(FilterUnit.test(t -> ItemMeta.class.getDeclaredMethod("setDisplayNameComponent", BaseComponent[].class), NoSuchMethodException.class))).add((itemMeta, locale, component) -> itemMeta.setDisplayName(MCAdventure.asLegacyString(component, locale))).find().orElseThrow(() -> new IllegalStateException("No valid set display name can be found."));
        GET_LORE = FilterUnit.create().add(FilterUnit.Item.create(itemMeta -> {
            List loreComponents = itemMeta.getLoreComponents();
            if (loreComponents == null) {
                return null;
            }
            BungeeComponentSerializer serializer = BungeeComponentSerializer.get();
            return loreComponents.stream().map(serializer::deserialize).collect(Collectors.toCollection(ArrayList::new));
        }).predicate(FilterUnit.test(t -> ItemMeta.class.getDeclaredMethod("getLoreComponents", new Class[0]), NoSuchMethodException.class))).add(itemMeta -> {
            List lore = itemMeta.getLore();
            if (lore == null) {
                return null;
            }
            return lore.stream().map(LegacyAdventureUtil::decode).collect(Collectors.toCollection(ArrayList::new));
        }).find().orElseThrow(() -> new IllegalStateException("No valid get lore can be found."));
        SET_LORE = FilterUnit.create().add(FilterUnit.Item.create((itemMeta, locale, components) -> {
            BungeeComponentSerializer serializer = BungeeComponentSerializer.get();
            List baseComponents = components.stream().map(serializer::serialize).collect(Collectors.toList());
            itemMeta.setLoreComponents(baseComponents);
        }).predicate(FilterUnit.test(t -> ItemMeta.class.getDeclaredMethod("setLoreComponents", List.class), NoSuchMethodException.class))).add((itemMeta, locale, components) -> itemMeta.setLore(components.stream().map(component -> MCAdventure.asItemString(component, locale)).collect(Collectors.toList()))).find().orElseThrow(() -> new IllegalStateException("No valid set lore can be found."));
    }

    private static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }
}

