/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.visual.sender;

import com.google.common.collect.HashMultimap;
import info.cho.passwords.fairy.bukkit.nms.BukkitNMSManager;
import info.cho.passwords.fairy.bukkit.visual.sender.VisualContainer;
import info.cho.passwords.fairy.bukkit.visual.sender.VisualData;
import info.cho.passwords.fairy.bukkit.visual.sender.impl.BukkitVisualData;
import info.cho.passwords.fairy.bukkit.visual.sender.impl.NewVisualData;
import info.cho.passwords.fairy.bukkit.visual.sender.impl.OldVisualData;
import info.cho.passwords.fairy.bukkit.visual.util.BlockPositionData;
import info.cho.passwords.fairy.data.MetaKey;
import info.cho.passwords.fairy.libs.packetevents.util.Vector3i;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerMultiBlockChange;
import info.cho.passwords.fairy.libs.xseries.XMaterial;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.data.MCMetadata;
import info.cho.passwords.fairy.mc.protocol.MCProtocol;
import info.cho.passwords.fairy.mc.util.BlockPosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class VisualBlockSender {
    public final MetaKey<VisualContainer> fakeBlocksMetadataKey = MetaKey.create("fairy:FakeBlockMap", VisualContainer.class);
    private final List<VisualData> visualDataList;

    public VisualBlockSender(BukkitNMSManager nmsManager) {
        this.visualDataList = Arrays.asList(new BukkitVisualData(), new OldVisualData(nmsManager), new NewVisualData(nmsManager));
    }

    public void send(Player player, Map<BlockPosition, XMaterial> blockMap, List<BlockPosition> replace, boolean send) {
        VisualContainer visualContainer = MCMetadata.provide(player).computeIfAbsent(this.fakeBlocksMetadataKey, VisualContainer::new);
        HashMultimap map = HashMultimap.create();
        for (Map.Entry<BlockPosition, XMaterial> entry : blockMap.entrySet()) {
            BlockPosition blockPosition = entry.getKey();
            XMaterial materialData = entry.getValue();
            if (materialData == null) {
                materialData = XMaterial.AIR;
            }
            XMaterial previous = visualContainer.put(blockPosition, materialData);
            if (!send || previous == materialData) continue;
            int x = blockPosition.getX();
            int y = blockPosition.getY();
            int z = blockPosition.getZ();
            int chunkX = x >> 4;
            int chunkY = y >> 4;
            int chunkZ = z >> 4;
            int posX = x - (chunkX << 4);
            int posZ = z - (chunkZ << 4);
            map.put((Object)new BlockPosition(chunkX, chunkY, chunkZ), (Object)new BlockPositionData(new BlockPosition(posX, y, posZ), materialData));
        }
        for (BlockPosition blockPosition : replace) {
            if (visualContainer.remove(blockPosition) == null) continue;
            int x2 = blockPosition.getX();
            int y2 = blockPosition.getY();
            int z2 = blockPosition.getZ();
            Block blockData = player.getWorld().getBlockAt(blockPosition.getX(), blockPosition.getY(), blockPosition.getZ());
            Material type = blockData.getType();
            int chunkX2 = x2 >> 4;
            int chunkY2 = y2 >> 4;
            int chunkZ2 = z2 >> 4;
            int posX2 = x2 - (chunkX2 << 4);
            int posZ2 = z2 - (chunkZ2 << 4);
            map.put((Object)new BlockPosition(chunkX2, chunkY2, chunkZ2), (Object)new BlockPositionData(new BlockPosition(posX2, y2, posZ2), XMaterial.matchXMaterial(type)));
        }
        MCPlayer mcPlayer = MCPlayer.from(player);
        if (send) {
            for (Map.Entry entry2 : map.asMap().entrySet()) {
                BlockPosition chunkPosition = (BlockPosition)entry2.getKey();
                Collection blocks = (Collection)entry2.getValue();
                WrapperPlayServerMultiBlockChange.EncodedBlock[] encodedBlocks = new WrapperPlayServerMultiBlockChange.EncodedBlock[blocks.size()];
                int i = 0;
                for (BlockPositionData positionData : blocks) {
                    BlockPosition b = positionData.getBlockPosition();
                    XMaterial materialData = positionData.getMaterial();
                    encodedBlocks[i] = new WrapperPlayServerMultiBlockChange.EncodedBlock(this.getIdByMaterial(materialData), b.getX(), b.getY(), b.getZ());
                    ++i;
                }
                WrapperPlayServerMultiBlockChange packet = new WrapperPlayServerMultiBlockChange(new Vector3i(chunkPosition.getX(), chunkPosition.getY(), chunkPosition.getZ()), false, encodedBlocks);
                MCProtocol.sendPacket(mcPlayer, packet);
            }
        }
    }

    public void clearFakeBlocks(Player player, boolean send) {
        VisualContainer visualContainer = MCMetadata.provide(player).getOrNull(this.fakeBlocksMetadataKey);
        if (visualContainer == null) {
            return;
        }
        if (send) {
            this.send(player, Collections.emptyMap(), new ArrayList<BlockPosition>(visualContainer.keySet()), true);
        } else {
            visualContainer.clear();
        }
    }

    private int getIdByMaterial(@NotNull XMaterial material) {
        for (VisualData visualData : this.visualDataList) {
            if (!visualData.isCapable()) continue;
            return visualData.getId(material);
        }
        return 0;
    }
}

