/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.command;

import info.cho.passwords.fairy.command.BaseCommand;
import info.cho.passwords.fairy.command.CommandContext;
import info.cho.passwords.fairy.command.CommandMeta;
import info.cho.passwords.fairy.command.CommandService;
import info.cho.passwords.fairy.command.ICommand;
import info.cho.passwords.fairy.command.PresenceProvider;
import info.cho.passwords.fairy.command.annotation.Arg;
import info.cho.passwords.fairy.command.annotation.Command;
import info.cho.passwords.fairy.command.annotation.CommandPresence;
import info.cho.passwords.fairy.command.annotation.CompletionHolder;
import info.cho.passwords.fairy.command.annotation.Order;
import info.cho.passwords.fairy.command.annotation.Usage;
import info.cho.passwords.fairy.command.argument.ArgCompletionHolder;
import info.cho.passwords.fairy.command.argument.ArgProperty;
import info.cho.passwords.fairy.command.completion.ArgCompletionHolderList;
import info.cho.passwords.fairy.command.completion.ArgCompletionHolderStringArray;
import info.cho.passwords.fairy.container.Autowired;
import info.cho.passwords.fairy.data.MetaStorage;
import info.cho.passwords.fairy.log.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class BaseCommandInitializer {
    @Autowired
    private static CommandService COMMAND_SERVICE;
    protected final BaseCommand baseCommand;

    public void init(String[] names, String permission) {
        this.baseCommand.names = names;
        this.baseCommand.permission = permission;
        this.baseCommand.metaStorage = MetaStorage.create();
        this.baseCommand.tabCompletion = new HashMap<String, ArgCompletionHolder>();
        Order order = this.baseCommand.getAnnotation(Order.class);
        if (order != null) {
            this.baseCommand.order = order.value();
        }
        this.initialisePresence();
        this.initialiseMethods();
        for (Class<?> innerClasses : this.baseCommand.getClass().getDeclaredClasses()) {
            if (!innerClasses.isAnnotationPresent(Command.class)) continue;
            this.initialiseSubCommand(innerClasses, null);
        }
        this.baseCommand.baseArgs = this.initialiseFields().toArray(new ArgProperty[0]);
        this.initialiseUsage();
        if (this.baseCommand.noArgCommand != null) {
            this.baseCommand.sortedCommands.add(this.baseCommand.noArgCommand);
        }
        this.baseCommand.sortedCommands.addAll(this.baseCommand.subCommands.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        this.baseCommand.sortedCommands.sort(Comparator.comparingInt(ICommand::order));
    }

    private void initialisePresence() {
        PresenceProvider<?> presenceProvider = null;
        CommandPresence annotation = this.baseCommand.getClass().getAnnotation(CommandPresence.class);
        if (annotation != null) {
            presenceProvider = COMMAND_SERVICE.getPresenceProviderByAnnotation(annotation);
        }
        this.baseCommand.presenceProvider = presenceProvider;
    }

    private void initialiseUsage() {
        Usage usageAnnotation = this.baseCommand.getClass().getAnnotation(Usage.class);
        boolean bl = this.baseCommand.displayOnPermission = usageAnnotation != null && usageAnnotation.displayOnPermission();
        if (usageAnnotation != null && usageAnnotation.overwrite()) {
            this.baseCommand.usage = usageAnnotation.value();
        } else {
            StringJoiner stringJoiner = new StringJoiner(" ");
            for (ArgProperty<?> arg : this.baseCommand.baseArgs) {
                stringJoiner.add("<" + arg.getKey() + ">");
            }
            String usage = "<baseCommand>" + (stringJoiner.length() > 0 ? " " : "") + stringJoiner + " ";
            if (usageAnnotation != null) {
                usage = usage + "- " + usageAnnotation.value();
            }
            this.baseCommand.usage = usage;
        }
    }

    private void initialiseMethods() {
        HashSet<Method> methods = new HashSet<Method>();
        methods.addAll(Arrays.asList(this.baseCommand.getClass().getMethods()));
        methods.addAll(Arrays.asList(this.baseCommand.getClass().getDeclaredMethods()));
        for (Method method : methods) {
            this.tryInitialiseCommandMethod(method);
            this.tryInitialiseCompletionHolderMethod(method);
        }
    }

    private void tryInitialiseCommandMethod(Method method) {
        Command command = method.getAnnotation(Command.class);
        if (command != null) {
            try {
                CommandMeta commandMeta = new CommandMeta(command, method, this.baseCommand);
                String[] names = command.value();
                boolean register = false;
                if (names.length == 0) {
                    Log.error("Command names cannot be empty, but empty on method " + method, new Object[0]);
                } else {
                    for (String name : names) {
                        if (name.equals("#")) {
                            if (this.baseCommand.noArgCommand != null) {
                                Log.error("Duplicate no arg sub command", new Object[0]);
                                continue;
                            }
                            this.baseCommand.noArgCommand = commandMeta;
                            register = true;
                            continue;
                        }
                        if (this.baseCommand.subCommands.containsKey(name.toLowerCase())) {
                            Log.error("Duplicate sub command name " + name, new Object[0]);
                            continue;
                        }
                        this.baseCommand.subCommands.computeIfAbsent(name.toLowerCase(), k -> new CopyOnWriteArraySet()).add(commandMeta);
                        register = true;
                    }
                }
                if (register) {
                    this.baseCommand.maxParameterCount = Math.max(commandMeta.getMaxParameterCount(), this.baseCommand.maxParameterCount);
                    this.baseCommand.requireInputParameterCount = Math.max(commandMeta.getRequireInputParameterCount(), this.baseCommand.requireInputParameterCount);
                }
            }
            catch (IllegalAccessException e) {
                Log.error("an error got thrown while registering @Command method", e, new Object[0]);
            }
        }
    }

    private void tryInitialiseCompletionHolderMethod(Method method) {
        CompletionHolder completion = method.getAnnotation(CompletionHolder.class);
        if (completion != null) {
            ArgCompletionHolder completionHolder;
            boolean hasParameter = false;
            if (method.getParameterCount() > 0) {
                hasParameter = true;
                if (method.getParameterCount() != 1 || !CommandContext.class.isAssignableFrom(method.getParameterTypes()[0])) {
                    Log.error("The parameter of @TabCompletion method should be CommandContext.", new UnsupportedOperationException(), new Object[0]);
                    return;
                }
            }
            if (String[].class.isAssignableFrom(method.getReturnType())) {
                completionHolder = new ArgCompletionHolderStringArray(method, this.baseCommand, hasParameter, completion.value());
            } else if (List.class.isAssignableFrom(method.getReturnType())) {
                completionHolder = new ArgCompletionHolderList(method, this.baseCommand, hasParameter, completion.value());
            } else {
                Log.error("The return type of @TabCompletion method should be String[] or List<String>", new UnsupportedOperationException(), new Object[0]);
                return;
            }
            this.baseCommand.tabCompletion.put(completion.value(), completionHolder);
        }
    }

    private List<ArgProperty<?>> initialiseFields() {
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(Arrays.asList(this.baseCommand.getClass().getFields()));
        fields.addAll(Arrays.asList(this.baseCommand.getClass().getDeclaredFields()));
        ArrayList argProperties = new ArrayList();
        for (Field field : fields) {
            this.initialiseArg(field, argProperties);
        }
        return argProperties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialiseArg(Field field, List<ArgProperty<?>> argProperties) {
        Arg arg;
        field.setAccessible(true);
        Command command = field.getAnnotation(Command.class);
        if (command != null) {
            if (!BaseCommand.class.isAssignableFrom(field.getType())) throw new IllegalArgumentException("Field " + field + " marked @Command but not using type " + BaseCommand.class);
            try {
                BaseCommand subCommand = (BaseCommand)field.get(this.baseCommand);
                if (subCommand == null) {
                    throw new IllegalArgumentException("Field " + field + " marked @Command but not initialised");
                }
                this.initialiseSubCommand(command, subCommand);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("An exception got thrown while registering field command " + field, e);
            }
        }
        if ((arg = field.getAnnotation(Arg.class)) == null) return;
        if (!ArgProperty.class.isAssignableFrom(field.getType())) throw new IllegalArgumentException("Field " + field + " marked @Arg but not using type " + ArgProperty.class);
        try {
            ArgProperty property = (ArgProperty)field.get(this.baseCommand);
            argProperties.add(property);
            if (property.getMissingArgument() == null) {
                property.onMissingArgument(commandContext -> this.baseCommand.onArgumentMissing((CommandContext)commandContext, this.baseCommand.getUsage((CommandContext)commandContext)));
            }
            if (property.getUnknownArgument() != null) return;
            property.onUnknownArgument(this.baseCommand::onArgumentFailed);
            return;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("An exception got thrown while registering field arg " + field, e);
        }
    }

    private void initialiseSubCommand(Class<?> clazz, @Nullable Command command) {
        BaseCommand subCommand;
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            subCommand = (BaseCommand)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("An exception got thrown while creating instance for " + clazz.getName() + " (Does it has no arg constructor?)", e);
        }
        this.initialiseSubCommand(command, subCommand);
    }

    private void initialiseSubCommand(@Nullable Command command, BaseCommand subCommand) {
        subCommand.parentCommand = this.baseCommand;
        if (command != null) {
            subCommand.init(command);
        } else {
            subCommand.init();
        }
        this.baseCommand.addSubCommand(subCommand.getCommandNames(), subCommand);
    }

    public BaseCommandInitializer(BaseCommand baseCommand) {
        this.baseCommand = baseCommand;
    }
}

