/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.command.parameter.impl;

import info.cho.passwords.fairy.command.CommandContext;
import info.cho.passwords.fairy.command.parameter.ArgTransformer;
import info.cho.passwords.fairy.container.object.Obj;

@Obj
public class DoubleArgTransformer
implements ArgTransformer<Double> {
    @Override
    public Class[] type() {
        return new Class[]{Double.class, Double.TYPE};
    }

    @Override
    public Double transform(CommandContext event, String source) {
        if (source.toLowerCase().contains("e")) {
            return (Double)this.fail(source + " is not a valid number.");
        }
        try {
            double parsed = Double.parseDouble(source);
            if (Double.isNaN(parsed) || !Double.isFinite(parsed)) {
                return (Double)this.fail(source + " is not a valid number.");
            }
            return parsed;
        }
        catch (NumberFormatException exception) {
            return (Double)this.fail(source + " is not a valid number.");
        }
    }
}

