/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.config;

import info.cho.passwords.fairy.ObjectSerializer;
import info.cho.passwords.fairy.config.ConfigurationException;
import info.cho.passwords.fairy.config.Converter;
import info.cho.passwords.fairy.config.FieldMapper;
import info.cho.passwords.fairy.config.Reflect;
import info.cho.passwords.fairy.config.Validator;
import info.cho.passwords.fairy.config.annotation.Convert;
import info.cho.passwords.fairy.container.Autowired;
import info.cho.passwords.fairy.container.SerializerFactory;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

final class Converters {
    @Autowired
    private static SerializerFactory SERIALIZER_FACTORY;
    private static final Map<Class<? extends Converter<?, ?>>, Converter<?, ?>> cache;
    static final IdentityConverter IDENTITY_CONVERTER;
    static final SimpleTypeConverter SIMPLE_TYPE_CONVERTER;
    static final EnumConverter ENUM_CONVERTER;
    static final ListConverter LIST_CONVERTER;
    static final SetConverter SET_CONVERTER;
    static final MapConverter MAP_CONVERTER;
    static final SimpleListConverter SIMPLE_LIST_CONVERTER;
    static final SimpleSetConverter SIMPLE_SET_CONVERTER;
    static final SimpleMapConverter SIMPLE_MAP_CONVERTER;
    static final ConfigurationElementConverter ELEMENT_CONVERTER;

    Converters() {
    }

    static Object convertTo(Converter.ConversionInfo info) {
        Converter<Object, Object> converter = Converters.selectConverter(info.getValueType(), info);
        converter.preConvertTo(info);
        return Converters.tryConvertTo(converter, info);
    }

    private static Object tryConvertTo(Converter<Object, Object> converter, Converter.ConversionInfo info) {
        try {
            return converter.convertTo(info.getValue(), info);
        }
        catch (ClassCastException e) {
            String msg = "Converter '" + converter.getClass().getSimpleName() + "' cannot convert value '" + info.getValue() + "' of field '" + info.getFieldName() + "' because it expects a different type.";
            throw new ConfigurationException(msg, e);
        }
    }

    static Object convertFrom(Converter.ConversionInfo info) {
        Converter<Object, Object> converter = Converters.selectConverter(info.getValueType(), info);
        converter.preConvertFrom(info);
        return Converters.tryConvertFrom(converter, info);
    }

    private static Object tryConvertFrom(Converter<Object, Object> converter, Converter.ConversionInfo info) {
        try {
            return converter.convertFrom(info.getMapValue(), info);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            String msg = "The value for field '" + info.getFieldName() + "' with type '" + Converters.getClsName(info.getFieldType()) + "' cannot be converted back to its original representation because a type mismatch occurred.";
            throw new ConfigurationException(msg, e);
        }
    }

    private static String getClsName(Class<?> cls) {
        return cls.getSimpleName();
    }

    private static Converter<Object, Object> selectConverter(Class<?> valueType, Converter.ConversionInfo info) {
        Converter<Object, Object> converter = Reflect.hasNoConvert(info.getField()) ? IDENTITY_CONVERTER : (Reflect.hasConverter(info.getField()) ? Converters.instantiateConverter(info.getField()) : (Reflect.isSimpleType(valueType) ? SIMPLE_TYPE_CONVERTER : Converters.selectNonSimpleConverter(valueType, info)));
        return Converters.toObjectConverter(converter);
    }

    private static Converter<Object, Object> selectNonSimpleConverter(Class<?> valueType, Converter.ConversionInfo info) {
        ObjectSerializer<?, ?> serializer;
        if (SERIALIZER_FACTORY != null && (serializer = SERIALIZER_FACTORY.findSerializer(valueType)) != null) {
            return new SerializerConverter(serializer);
        }
        Converter<Enum<?>, String> converter = Reflect.isEnumType(valueType) || valueType == String.class ? ENUM_CONVERTER : (Reflect.isContainerType(valueType) ? Converters.selectContainerConverter(valueType, info) : ELEMENT_CONVERTER);
        return Converters.toObjectConverter(converter);
    }

    private static Converter<?, ?> instantiateConverter(Field field) {
        Convert convert = field.getAnnotation(Convert.class);
        return cache.computeIfAbsent(convert.value(), cls -> {
            Validator.checkConverterHasNoArgsConstructor(cls, field.getName());
            return (Converter)Reflect.newInstance(cls);
        });
    }

    private static Converter<?, ?> selectContainerConverter(Class<?> valueType, Converter.ConversionInfo info) {
        if (info.hasElementType()) {
            return Converters.selectElementTypeContainerConverter(valueType);
        }
        return Converters.selectSimpleContainerConverter(valueType);
    }

    private static Converter<?, ?> selectElementTypeContainerConverter(Class<?> valueType) {
        return Converters.selector(LIST_CONVERTER, SET_CONVERTER, MAP_CONVERTER).apply(valueType);
    }

    private static Converter<?, ?> selectSimpleContainerConverter(Class<?> valueType) {
        return Converters.selector(SIMPLE_LIST_CONVERTER, SIMPLE_SET_CONVERTER, SIMPLE_MAP_CONVERTER).apply(valueType);
    }

    static <R> Function<Class<?>, R> selector(R listValue, R setValue, R mapValue) {
        return containerClass -> {
            if (List.class.isAssignableFrom((Class<?>)containerClass)) {
                return listValue;
            }
            if (Set.class.isAssignableFrom((Class<?>)containerClass)) {
                return setValue;
            }
            return mapValue;
        };
    }

    static String selectContainerName(Class<?> containerType) {
        return Converters.selector("list", "set", "map").apply(containerType);
    }

    private static Converter<Object, Object> toObjectConverter(Converter<?, ?> converter) {
        Converter<Object, Object> c = converter;
        return c;
    }

    private static Function<Object, ?> createToConversionFunction(Object element, Converter.ConversionInfo info) {
        Validator.checkNestingLevel(element, info);
        if (Reflect.isContainerType(element.getClass())) {
            info.incCurrentNestingLevel();
        }
        Converter<Object, Object> converter = Converters.selectNonSimpleConverter(element.getClass(), info);
        return o -> converter.convertTo(o, info);
    }

    private static Function<Object, ?> createFromConversionFunction(Object element, Converter.ConversionInfo info) {
        boolean currentLevelSameAsExpected = info.getNestingLevel() == info.getCurrentNestingLevel();
        Validator.checkCurrentLevelSameAsExpectedRequiresMapOrString(currentLevelSameAsExpected, element, info);
        if (element instanceof Map && currentLevelSameAsExpected) {
            ObjectSerializer<?, ?> serializer;
            if (SERIALIZER_FACTORY != null && (serializer = SERIALIZER_FACTORY.findSerializer(info.getElementType())) != null) {
                SerializerConverter converter = new SerializerConverter(serializer);
                return o -> converter.convertFrom(o, info);
            }
            return o -> {
                Map<String, Object> map = Converters.toTypeMap(o, null);
                Object inst = Reflect.newInstance(info.getElementType());
                FieldMapper.instanceFromMap(inst, map, info.getMappingInfo());
                return inst;
            };
        }
        if (element instanceof String && currentLevelSameAsExpected) {
            return Converters.createNonSimpleConverter(info.getElementType(), element, info);
        }
        info.incCurrentNestingLevel();
        return Converters.createNonSimpleConverter(info.getElementType(), element, info);
    }

    private static Function<Object, ?> createNonSimpleConverter(Class<?> elementType, Object element, Converter.ConversionInfo info) {
        Converter<Object, Object> converter = Converters.selectNonSimpleConverter(elementType, info);
        return o -> converter.convertFrom(o, info);
    }

    private static Map<String, Object> toTypeMap(Object value, String fn) {
        Validator.checkIsMap(value, fn);
        Validator.checkMapKeysAreStrings((Map)value, fn);
        Map map = (Map)value;
        return map;
    }

    static {
        cache = new WeakHashMap();
        IDENTITY_CONVERTER = new IdentityConverter();
        SIMPLE_TYPE_CONVERTER = new SimpleTypeConverter();
        ENUM_CONVERTER = new EnumConverter();
        LIST_CONVERTER = new ListConverter();
        SET_CONVERTER = new SetConverter();
        MAP_CONVERTER = new MapConverter();
        SIMPLE_LIST_CONVERTER = new SimpleListConverter();
        SIMPLE_SET_CONVERTER = new SimpleSetConverter();
        SIMPLE_MAP_CONVERTER = new SimpleMapConverter();
        ELEMENT_CONVERTER = new ConfigurationElementConverter();
    }

    private static final class IdentityConverter
    implements Converter<Object, Object> {
        private IdentityConverter() {
        }

        @Override
        public Object convertTo(Object element, Converter.ConversionInfo info) {
            return element;
        }

        @Override
        public Object convertFrom(Object element, Converter.ConversionInfo info) {
            return element;
        }
    }

    private static final class SimpleTypeConverter
    implements Converter<Object, Object> {
        private SimpleTypeConverter() {
        }

        @Override
        public Object convertTo(Object element, Converter.ConversionInfo info) {
            return element;
        }

        @Override
        public Object convertFrom(Object element, Converter.ConversionInfo info) {
            if (info.getFieldType() == element.getClass()) {
                return element;
            }
            if (element instanceof Number) {
                return this.convertNumber(info.getFieldType(), (Number)element);
            }
            if (element instanceof String) {
                return this.convertString((String)element);
            }
            return element;
        }

        private Object convertNumber(Class<?> target, Number value) {
            if (target == Byte.TYPE || target == Byte.class) {
                return value.byteValue();
            }
            if (target == Short.TYPE || target == Short.class) {
                return value.shortValue();
            }
            if (target == Integer.TYPE || target == Integer.class) {
                return value.intValue();
            }
            if (target == Long.TYPE || target == Long.class) {
                return value.longValue();
            }
            if (target == Float.TYPE || target == Float.class) {
                return Float.valueOf(value.floatValue());
            }
            if (target == Double.TYPE || target == Double.class) {
                return value.doubleValue();
            }
            String msg = "Number '" + value + "' cannot be converted to type '" + target + "'";
            throw new IllegalArgumentException(msg);
        }

        private Object convertString(String s) {
            int length = s.length();
            if (length == 0) {
                String msg = "An empty string cannot be converted to a character.";
                throw new IllegalArgumentException(msg);
            }
            if (length > 1) {
                String msg = "String '" + s + "' is too long to be converted to a character";
                throw new IllegalArgumentException(msg);
            }
            return Character.valueOf(s.charAt(0));
        }
    }

    private static final class SerializerConverter
    implements Converter<Object, Object> {
        private ObjectSerializer serializer;

        public SerializerConverter(ObjectSerializer serializer) {
            this.serializer = serializer;
        }

        @Override
        public Object convertTo(Object element, Converter.ConversionInfo info) {
            return this.serializer.serialize(element);
        }

        @Override
        public Object convertFrom(Object element, Converter.ConversionInfo info) {
            return this.serializer.deserialize(element);
        }
    }

    private static final class EnumConverter
    implements Converter<Enum<?>, String> {
        private EnumConverter() {
        }

        @Override
        public String convertTo(Enum<?> element, Converter.ConversionInfo info) {
            return element.toString();
        }

        @Override
        public void preConvertFrom(Converter.ConversionInfo info) {
            Validator.checkEnumValueIsString(info);
        }

        @Override
        public Enum<?> convertFrom(String element, Converter.ConversionInfo info) {
            Class<? extends Enum> cls = this.getEnumClass(info);
            try {
                Enum enm = Enum.valueOf(cls, element);
                return enm;
            }
            catch (IllegalArgumentException e) {
                Validator.checkElementTypeIsEnumType(cls, info);
                String in = this.selectWord(info);
                String msg = "Cannot initialize " + in + " because there is no enum constant '" + element + "'.\nValid constants are: " + Arrays.toString(cls.getEnumConstants());
                throw new IllegalArgumentException(msg, e);
            }
        }

        private String selectWord(Converter.ConversionInfo info) {
            String fn = info.getFieldName();
            if (Reflect.isContainerType(info.getFieldType())) {
                String w = Converters.selectContainerName(info.getValueType());
                return "an enum element of " + w + " '" + fn + "'";
            }
            return "enum '" + fn + "' ";
        }

        private Class<? extends Enum> getEnumClass(Converter.ConversionInfo info) {
            return !info.hasElementType() ? info.getValue().getClass() : info.getElementType();
        }
    }

    private static final class ConfigurationElementConverter
    implements Converter<Object, Object> {
        private ConfigurationElementConverter() {
        }

        @Override
        public Object convertTo(Object element, Converter.ConversionInfo info) {
            return FieldMapper.instanceToMap(element, info.getMappingInfo());
        }

        @Override
        public void preConvertTo(Converter.ConversionInfo info) {
            Validator.checkTypeIsConfigurationElement(info.getValueType(), info.getFieldName());
            Validator.checkTypeHasNoArgsConstructor(info);
        }

        @Override
        public Object convertFrom(Object element, Converter.ConversionInfo info) {
            Validator.checkElementIsConvertibleToConfigurationElement(element, info);
            Object newInstance = Reflect.newInstance(info.getValueType());
            Map typeMap = Converters.toTypeMap(element, info.getFieldName());
            FieldMapper.instanceFromMap(newInstance, typeMap, info.getMappingInfo());
            return newInstance;
        }

        @Override
        public void preConvertFrom(Converter.ConversionInfo info) {
            Validator.checkTypeHasNoArgsConstructor(info);
            Validator.checkTypeIsConfigurationElement(info.getValueType(), info.getFieldName());
        }
    }

    private static final class ListConverter
    implements Converter<List<?>, List<?>> {
        private ListConverter() {
        }

        @Override
        public List<?> convertTo(List<?> element, Converter.ConversionInfo info) {
            if (element.isEmpty()) {
                return element;
            }
            Object o = element.get(0);
            Function f = Converters.createToConversionFunction(o, info);
            return element.stream().map(f).collect(Collectors.toList());
        }

        @Override
        public void preConvertTo(Converter.ConversionInfo info) {
            Validator.checkElementType(info);
            Validator.checkContainerValuesNotNull(info);
            Validator.checkContainerTypes(info);
        }

        @Override
        public List<?> convertFrom(List<?> element, Converter.ConversionInfo info) {
            if (element.isEmpty()) {
                return element;
            }
            Object o = element.get(0);
            Function f = Converters.createFromConversionFunction(o, info);
            return element.stream().map(f).collect(Collectors.toList());
        }

        @Override
        public void preConvertFrom(Converter.ConversionInfo info) {
            Validator.checkElementType(info);
        }
    }

    private static final class SetConverter
    implements Converter<Set<?>, Set<?>> {
        private SetConverter() {
        }

        @Override
        public Set<?> convertTo(Set<?> element, Converter.ConversionInfo info) {
            if (element.isEmpty()) {
                return element;
            }
            Object o = element.iterator().next();
            Function f = Converters.createToConversionFunction(o, info);
            return element.stream().map(f).collect(Collectors.toSet());
        }

        @Override
        public void preConvertTo(Converter.ConversionInfo info) {
            Validator.checkElementType(info);
            Validator.checkContainerValuesNotNull(info);
            Validator.checkContainerTypes(info);
        }

        @Override
        public Set<?> convertFrom(Set<?> element, Converter.ConversionInfo info) {
            if (element.isEmpty()) {
                return element;
            }
            Object o = element.iterator().next();
            Function f = Converters.createFromConversionFunction(o, info);
            return element.stream().map(f).collect(Collectors.toSet());
        }

        @Override
        public void preConvertFrom(Converter.ConversionInfo info) {
            Validator.checkElementType(info);
        }
    }

    private static final class MapConverter
    implements Converter<Map<?, ?>, Map<?, ?>> {
        private MapConverter() {
        }

        @Override
        public Map<?, ?> convertTo(Map<?, ?> element, Converter.ConversionInfo info) {
            if (element.isEmpty()) {
                return element;
            }
            Object o = element.values().iterator().next();
            Function cf = Converters.createToConversionFunction(o, info);
            Function<Map.Entry, Object> f = e -> cf.apply(e.getValue());
            return element.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, f));
        }

        @Override
        public void preConvertTo(Converter.ConversionInfo info) {
            Validator.checkElementType(info);
            Validator.checkMapKeysAndValues(info);
            Validator.checkContainerTypes(info);
        }

        @Override
        public Map<?, ?> convertFrom(Map<?, ?> element, Converter.ConversionInfo info) {
            if (element.isEmpty()) {
                return element;
            }
            Object o = element.values().iterator().next();
            Function cf = Converters.createFromConversionFunction(o, info);
            Function<Map.Entry, Object> f = e -> cf.apply(e.getValue());
            return element.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, f));
        }

        @Override
        public void preConvertFrom(Converter.ConversionInfo info) {
            Validator.checkElementType(info);
        }
    }

    private static final class SimpleListConverter
    implements Converter<List<?>, List<?>> {
        private SimpleListConverter() {
        }

        @Override
        public List<?> convertTo(List<?> element, Converter.ConversionInfo info) {
            return element;
        }

        @Override
        public void preConvertTo(Converter.ConversionInfo info) {
            Validator.checkContainerValuesNotNull(info);
            Validator.checkContainerValuesSimpleType(info);
        }

        @Override
        public List<?> convertFrom(List<?> element, Converter.ConversionInfo info) {
            return element;
        }
    }

    private static final class SimpleSetConverter
    implements Converter<Set<?>, Set<?>> {
        private SimpleSetConverter() {
        }

        @Override
        public Set<?> convertTo(Set<?> element, Converter.ConversionInfo info) {
            return element;
        }

        @Override
        public void preConvertTo(Converter.ConversionInfo info) {
            Validator.checkContainerValuesNotNull(info);
            Validator.checkContainerValuesSimpleType(info);
        }

        @Override
        public Set<?> convertFrom(Set<?> element, Converter.ConversionInfo info) {
            return element;
        }
    }

    private static final class SimpleMapConverter
    implements Converter<Map<?, ?>, Map<?, ?>> {
        private SimpleMapConverter() {
        }

        @Override
        public Map<?, ?> convertTo(Map<?, ?> element, Converter.ConversionInfo info) {
            return element;
        }

        @Override
        public void preConvertTo(Converter.ConversionInfo info) {
            Validator.checkMapKeysAndValues(info);
            Validator.checkContainerValuesSimpleType(info);
        }

        @Override
        public Map<?, ?> convertFrom(Map<?, ?> element, Converter.ConversionInfo info) {
            return element;
        }
    }
}

