/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.config.filter;

import info.cho.passwords.fairy.config.annotation.NestedConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface FieldFilter
extends Predicate<Field> {
    default public FieldFilter and(@NotNull Predicate<? super Field> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test((Field)t);
    }

    default public List<? extends Field> filterDeclaredFieldsOf(Class<?> cls) {
        NestedConfig annotation = cls.getAnnotation(NestedConfig.class);
        List<Object> accepted = annotation == null ? Collections.emptyList() : Arrays.asList(annotation.value());
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> current = cls;
        do {
            if (current != cls && !accepted.contains(current)) continue;
            fields.addAll(Arrays.asList(current.getDeclaredFields()));
        } while ((current = current.getSuperclass()) != Object.class && current != null);
        return fields.stream().filter(this).collect(Collectors.toList());
    }
}

