/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.config.format;

import info.cho.passwords.fairy.config.format.FieldNameFormatter;

public enum FieldNameFormatters implements FieldNameFormatter
{
    IDENTITY{

        @Override
        public String fromFieldName(String fn) {
            return fn;
        }
    }
    ,
    LOWER_UNDERSCORE{

        @Override
        public String fromFieldName(String fn) {
            StringBuilder builder = new StringBuilder(fn.length());
            for (char c : fn.toCharArray()) {
                if (Character.isLowerCase(c)) {
                    builder.append(c);
                    continue;
                }
                if (!Character.isUpperCase(c)) continue;
                c = Character.toLowerCase(c);
                builder.append('_').append(c);
            }
            return builder.toString();
        }
    }
    ,
    LOWER_CASE{

        @Override
        public String fromFieldName(String fn) {
            return fn.toLowerCase();
        }
    }
    ,
    UPPER_UNDERSCORE{

        @Override
        public String fromFieldName(String fieldName) {
            StringBuilder builder = new StringBuilder(fieldName.length());
            for (char c : fieldName.toCharArray()) {
                if (Character.isLowerCase(c)) {
                    builder.append(Character.toUpperCase(c));
                    continue;
                }
                if (!Character.isUpperCase(c)) continue;
                builder.append('_').append(c);
            }
            return builder.toString();
        }
    };

}

