/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.config.yaml;

import info.cho.passwords.fairy.config.Comments;
import info.cho.passwords.fairy.config.format.FieldNameFormatter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class YamlComments {
    private final Comments comments;

    YamlComments(Comments comments) {
        this.comments = comments;
    }

    String classCommentsAsString() {
        List<String> classComments = this.comments.getClassComments();
        return this.commentListToString(classComments);
    }

    Map<String, String> fieldCommentAsStrings(FieldNameFormatter formatter) {
        Map<String, List<String>> fieldComments = this.comments.getFieldComments();
        return fieldComments.entrySet().stream().map(e -> this.toFormattedStringCommentEntry((Map.Entry<String, List<String>>)e, formatter)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map.Entry<String, String> toFormattedStringCommentEntry(Map.Entry<String, List<String>> entry, FieldNameFormatter formatter) {
        String fieldComments = this.commentListToString(entry.getValue());
        String formattedKey = formatter.fromFieldName(entry.getKey());
        return new MapEntry<String, String>(formattedKey, fieldComments);
    }

    private String commentListToString(List<String> comments) {
        return comments.stream().map(this::toCommentLine).collect(Collectors.joining("\n"));
    }

    private String toCommentLine(String comment) {
        return comment.isEmpty() ? "" : "# " + comment;
    }

    private static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }
    }
}

