/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.config.yaml;

import info.cho.passwords.fairy.config.Comments;
import info.cho.passwords.fairy.config.ConfigurationSource;
import info.cho.passwords.fairy.config.yaml.YamlComments;
import info.cho.passwords.fairy.config.yaml.YamlConfiguration;
import info.cho.passwords.fairy.libs.snakeyaml.Yaml;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class YamlSource
implements ConfigurationSource<YamlConfiguration> {
    private final Path configPath;
    private final YamlConfiguration.YamlProperties props;
    private final Yaml yaml;

    public YamlSource(Path configPath, YamlConfiguration.YamlProperties props) {
        this.configPath = Objects.requireNonNull(configPath);
        this.props = props;
        this.yaml = new Yaml(props.getConstructor(), props.getRepresenter(), props.getOptions(), props.getResolver());
    }

    @Override
    public void saveConfiguration(YamlConfiguration config, Map<String, Object> map) throws IOException {
        this.createParentDirectories();
        CommentAdder adder = new CommentAdder(this.yaml.dump(map), config.getComments(), this.props);
        String commentedDump = adder.getCommentedDump();
        Files.write(this.configPath, commentedDump.getBytes(), new OpenOption[0]);
    }

    private void createParentDirectories() throws IOException {
        Path parentDir = this.configPath.getParent();
        if (!Files.isDirectory(parentDir, new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
    }

    @Override
    public Map<String, Object> loadConfiguration(YamlConfiguration config) throws IOException {
        String cfg = this.readConfig();
        return (Map)this.yaml.load(cfg);
    }

    private String readConfig() throws IOException {
        return Files.lines(this.configPath).collect(Collectors.joining("\n"));
    }

    private static final class CommentAdder {
        private static final Pattern PREFIX_PATTERN = Pattern.compile("(^\\w+):(.*)");
        private static final Pattern SPACES_PATTERN = Pattern.compile("^[ \\s\\n]+.*");
        private final String dump;
        private final Comments comments;
        private final YamlComments yamlComments;
        private final YamlConfiguration.YamlProperties props;
        private final StringBuilder builder;
        private StringBuilder data = new StringBuilder();

        private CommentAdder(String dump, Comments comments, YamlConfiguration.YamlProperties props) {
            this.dump = dump;
            this.props = props;
            this.comments = comments;
            this.yamlComments = new YamlComments(comments);
            this.builder = new StringBuilder(dump.length());
        }

        public String getCommentedDump() {
            this.addComments(this.props.getPrependedComments());
            this.addClassComments();
            this.addFieldComments();
            this.addComments(this.props.getAppendedComments());
            return this.builder.toString();
        }

        private void addComments(List<String> comments) {
            for (String comment : comments) {
                if (!comment.isEmpty()) {
                    this.builder.append("# ").append(comment);
                }
                this.builder.append('\n');
            }
        }

        private void addClassComments() {
            if (this.comments.hasClassComments()) {
                this.builder.append(this.yamlComments.classCommentsAsString());
                this.builder.append("\n");
            }
        }

        private void addFieldComments() {
            if (this.comments.hasFieldComments()) {
                List<String> dumpLines = Arrays.asList(this.dump.split("\n"));
                this.addDumpLines(dumpLines);
            } else {
                this.builder.append(this.dump);
            }
        }

        private void addDumpLines(List<String> dumpLines) {
            for (String dumpLine : dumpLines) {
                Matcher m = PREFIX_PATTERN.matcher(this.trimStart(dumpLine));
                if (m.matches()) {
                    this.addFieldComment(dumpLine, this.trimStart(dumpLine), m);
                }
                this.builder.append(dumpLine).append('\n');
            }
        }

        private void addFieldComment(String dumpLine, String dumpLineWithTrim, Matcher matcher) {
            Map<String, String> map = this.yamlComments.fieldCommentAsStrings(this.props.getFormatter());
            Matcher spacesMatch = SPACES_PATTERN.matcher(dumpLine);
            String value = matcher.group(2);
            if (value.equals("") || value.isEmpty()) {
                if (!spacesMatch.matches()) {
                    this.data = new StringBuilder();
                }
                this.data.append(matcher.group(1)).append(".");
            } else if (!spacesMatch.matches()) {
                this.data = new StringBuilder();
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String[] valueSplit;
                String prefix = entry.getKey() + ":";
                String lineData = this.data.toString().replaceFirst("[.]$", "");
                String[] splitPrefix = prefix.split("\\.");
                if (!dumpLine.startsWith(prefix) && (!lineData.startsWith(splitPrefix[0]) || !dumpLineWithTrim.startsWith(splitPrefix[splitPrefix.length - 1]))) continue;
                String newDumpLine = dumpLine.replaceAll("^\\s+", "");
                int count = dumpLine.length() - newDumpLine.length();
                for (String val : valueSplit = entry.getValue().split("\n")) {
                    int updateCount = val.length() + count;
                    char fill = ' ';
                    this.builder.append(new String(new char[updateCount - val.length()]).replace('\u0000', fill)).append(val).append("\n");
                }
            }
        }

        private String trimStart(String value) {
            return value.replaceFirst("^\\s+", "");
        }
    }
}

