/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.container;

import info.cho.passwords.fairy.container.node.ContainerNode;
import info.cho.passwords.fairy.container.object.ContainerObj;
import info.cho.passwords.fairy.log.Log;
import info.cho.passwords.fairy.util.Stacktrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.jetbrains.annotations.Nullable;

public class ContainerLogger {
    public static void report(ContainerNode node, ContainerObj obj, @Nullable Throwable throwable, String ... messages) {
        Log.error("!-------------------!", new Object[0]);
        Log.error("An error was reported with Fairy container system!!", new Object[0]);
        Log.error("Node: " + node.name(), new Object[0]);
        Log.error("Component: " + obj.getType().getName(), new Object[0]);
        Log.error(" ", new Object[0]);
        Log.error("Messages:", new Object[0]);
        for (String message : messages) {
            Log.error(">    " + message, new Object[0]);
        }
        Path path = ContainerLogger.write(node, obj, messages, throwable);
        if (throwable != null) {
            Log.error(" ", new Object[0]);
            Log.error("The error stacktrace: ", new Object[0]);
            Log.error(Stacktrace.simplifyStacktrace(throwable));
        }
        Log.error(" ", new Object[0]);
        if (path != null) {
            Log.error("The error has been written to the log file.", new Object[0]);
            Log.error("Path: " + path.toAbsolutePath(), new Object[0]);
        }
        Log.error("!-------------------!", new Object[0]);
    }

    public static Path write(ContainerNode node, @Nullable ContainerObj obj, @Nullable String[] messages, @Nullable Throwable throwable) {
        String time = DateTimeFormatter.ISO_LOCAL_DATE.format(LocalDate.now());
        Path directory = Paths.get("fairy", new String[0]);
        Path path = directory.resolve(time + ".log");
        int counter = 2;
        while (Files.exists(path, new LinkOption[0])) {
            path = directory.resolve(time + "-" + counter + ".log");
            ++counter;
        }
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
            StringWriter out = new StringWriter();
            PrintWriter builder = new PrintWriter(out);
            builder.append("Node: ").append(node.name()).append("\n");
            builder.append("Classes: ").append("\n");
            node.graph().forEachClockwise(chain -> builder.append("-> ").append(chain.getType().getName()).append("\n"));
            if (obj != null) {
                builder.append(String.format("Node Object: %s\n", obj.getType().getName()));
                builder.append(String.format("  dependencies: %s\n", obj.getDependencies()));
                builder.append(String.format("  Component instance provider: %s\n", obj.getInstanceProvider()));
                builder.append(String.format("  Component thread mode: %s\n", new Object[]{obj.getThreadingMode()}));
            }
            builder.append("--------------------\n");
            if (messages != null) {
                for (String message : messages) {
                    builder.append(message).append("\n");
                }
            }
            if (throwable != null) {
                throwable.printStackTrace(builder);
            }
            Files.write(path, out.toString().getBytes(), StandardOpenOption.CREATE_NEW);
            return path;
        }
        catch (IOException ex) {
            Log.error("Cannot write error log file", ex, new Object[0]);
            return null;
        }
    }
}

