/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.container;

import info.cho.passwords.fairy.util.AsyncUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Threading {
    public Mode value();

    public static enum Mode {
        SYNC{

            @Override
            public CompletableFuture<?> execute(Runnable runnable) {
                runnable.run();
                return AsyncUtils.empty();
            }

            @Override
            public <T> CompletableFuture<T> execute(Supplier<T> supplier) {
                return CompletableFuture.completedFuture(supplier.get());
            }
        }
        ,
        ASYNC{

            @Override
            public CompletableFuture<?> execute(Runnable runnable) {
                return CompletableFuture.runAsync(runnable);
            }

            @Override
            public <T> CompletableFuture<T> execute(Supplier<T> supplier) {
                return CompletableFuture.supplyAsync(supplier);
            }

            @Override
            public Executor getExecutor() {
                return CompletableFuture::runAsync;
            }
        };


        public Executor getExecutor() {
            return this::execute;
        }

        public CompletableFuture<?> execute(Runnable runnable) {
            throw new UnsupportedOperationException();
        }

        public <T> CompletableFuture<T> execute(Supplier<T> supplier) {
            throw new UnsupportedOperationException();
        }
    }
}

