/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.container.node.scanner;

import info.cho.passwords.fairy.Debug;
import info.cho.passwords.fairy.container.DependsOn;
import info.cho.passwords.fairy.container.InjectableComponent;
import info.cho.passwords.fairy.container.binder.ContainerObjectBinder;
import info.cho.passwords.fairy.container.configuration.Configuration;
import info.cho.passwords.fairy.container.configuration.TestConfiguration;
import info.cho.passwords.fairy.container.node.ContainerNode;
import info.cho.passwords.fairy.container.node.scanner.ContainerNodeConfigurationScanner;
import info.cho.passwords.fairy.container.node.scanner.ContainerNodeLegacyScanner;
import info.cho.passwords.fairy.container.object.ContainerObj;
import info.cho.passwords.fairy.container.object.provider.ConstructorInstanceProvider;
import info.cho.passwords.fairy.container.processor.ContainerNodeClassScanProcessor;
import info.cho.passwords.fairy.container.processor.ContainerProcessors;
import info.cho.passwords.fairy.log.Log;
import info.cho.passwords.fairy.util.Utility;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ContainerNodeClassScanner {
    private final ContainerProcessors processors;
    private final ContainerObjectBinder binder;
    private final String name;
    private final ContainerNode node;
    private final List<String> classPaths = new ArrayList<String>();
    private final List<String> excludedClassPaths = new ArrayList<String>();
    private final List<URL> urls = new ArrayList<URL>();
    private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
    private ContainerNode objNode;

    public void scan() {
        this.objNode = ContainerNode.create(this.name + ":obj", this.binder);
        this.node.addChild(this.objNode);
        ClassGraph classGraph = this.createClassGraph();
        try (ScanResult scanResult = classGraph.scan(4);){
            this.loadComponentClasses(scanResult);
            this.loadComponentConfigurations(scanResult, Configuration.class, false);
            if (Debug.UNIT_TEST) {
                this.loadComponentConfigurations(scanResult, TestConfiguration.class, true);
            }
            this.loadLegacyComponentClasses(scanResult);
            this.callProcessors(scanResult);
        }
    }

    private void callProcessors(ScanResult scanResult) {
        for (ContainerNodeClassScanProcessor nodeClassScanProcessor : this.processors.nodeClassScanProcessors()) {
            nodeClassScanProcessor.processClassScan(this.node, scanResult);
        }
    }

    private void loadLegacyComponentClasses(ScanResult scanResult) {
        new ContainerNodeLegacyScanner(scanResult, this.binder, this).load();
    }

    private void loadComponentConfigurations(ScanResult scanResult, Class<? extends Annotation> annotation, boolean override) {
        ClassInfoList classes = scanResult.getClassesWithAnnotation(annotation);
        for (ClassInfo classInfo : classes) {
            Class<?> javaClass;
            try {
                javaClass = classInfo.loadClass();
            }
            catch (Throwable t) {
                Log.error(t);
                continue;
            }
            this.loadConfigurationClass(javaClass, override);
        }
    }

    private void loadConfigurationClass(Class<?> javaClass, boolean override) {
        new ContainerNodeConfigurationScanner(this.binder, javaClass, override, this).load();
    }

    private void loadComponentClasses(ScanResult scanResult) {
        ClassInfoList classes = scanResult.getClassesWithAnnotation(InjectableComponent.class);
        this.loadComponentClasses(classes, this.node);
    }

    void loadComponentClasses(ClassInfoList classes, ContainerNode node) {
        this.loadComponentClasses(classes, node, obj -> {});
    }

    void loadComponentClasses(ClassInfoList classes, ContainerNode node, Consumer<ContainerObj> closure) {
        for (ClassInfo classInfo : classes) {
            Class<?> javaClass;
            try {
                javaClass = classInfo.loadClass();
            }
            catch (Throwable t) {
                Log.error(t);
                continue;
            }
            ContainerObj object = this.getOrLoadComponentObject(javaClass);
            this.addComponentClass(object, node, closure);
        }
    }

    private ContainerObj getOrLoadComponentObject(Class<?> javaClass) {
        ContainerObj binding = this.binder.getExactBinding(javaClass);
        if (binding != null) {
            return binding;
        }
        ContainerObj object = this.createObject(javaClass);
        InjectableComponent annotation = object.getType().getAnnotation(InjectableComponent.class);
        if (annotation != null) {
            object.setScope(annotation.scope());
        }
        try {
            ConstructorInstanceProvider provider = new ConstructorInstanceProvider(javaClass);
            object.setInstanceProvider(provider);
        }
        catch (Throwable t) {
            throw new IllegalStateException("An error occurred while creating the component instance provider", t);
        }
        this.processDependsOn(object);
        return object;
    }

    private void processDependsOn(ContainerObj object) {
        Class<?> type = object.getType();
        for (Class<?> superClass : Utility.getSuperAndInterfaces(type)) {
            DependsOn annotation = superClass.getDeclaredAnnotation(DependsOn.class);
            if (annotation == null) continue;
            for (Class<?> dependency : annotation.value()) {
                object.addDependency(dependency);
            }
        }
    }

    ContainerObj createObject(Class<?> javaClass) {
        ContainerObj object = ContainerObj.create(javaClass);
        this.binder.bind(javaClass, object);
        return object;
    }

    void addComponentClass(ContainerObj object, ContainerNode node) {
        this.addComponentClass(object, node, $ -> {});
    }

    void addComponentClass(ContainerObj object, ContainerNode node, Consumer<ContainerObj> closure) {
        node.addObj(object);
    }

    private ClassGraph createClassGraph() {
        ClassGraph classGraph = new ClassGraph().enableAllInfo().verbose(false);
        for (String classPath : this.classPaths) {
            classGraph.acceptPackages(classPath);
        }
        for (String classPath : this.excludedClassPaths) {
            classGraph.rejectPackages(classPath);
        }
        if (!this.urls.isEmpty()) {
            classGraph.overrideClasspath(this.urls);
        }
        if (!this.classLoaders.isEmpty()) {
            classGraph.overrideClassLoaders(this.classLoaders.toArray(new ClassLoader[0]));
        }
        return classGraph;
    }

    public ContainerNodeClassScanner(ContainerProcessors processors, ContainerObjectBinder binder, String name, ContainerNode node) {
        this.processors = processors;
        this.binder = binder;
        this.name = name;
        this.node = node;
    }

    public ContainerProcessors getProcessors() {
        return this.processors;
    }

    public ContainerObjectBinder getBinder() {
        return this.binder;
    }

    public String getName() {
        return this.name;
    }

    public ContainerNode getNode() {
        return this.node;
    }

    public List<String> getClassPaths() {
        return this.classPaths;
    }

    public List<String> getExcludedClassPaths() {
        return this.excludedClassPaths;
    }

    public List<URL> getUrls() {
        return this.urls;
    }

    public List<ClassLoader> getClassLoaders() {
        return this.classLoaders;
    }

    public ContainerNode getObjNode() {
        return this.objNode;
    }
}

