/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.container.object.provider;

import info.cho.passwords.fairy.container.ContainerConstruct;
import info.cho.passwords.fairy.container.object.provider.InstanceProvider;
import info.cho.passwords.fairy.util.AccessUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;

public class ConstructorInstanceProvider
implements InstanceProvider {
    private final Class<?> type;
    private final Constructor<?> constructor;

    public ConstructorInstanceProvider(Class<?> type) throws ReflectiveOperationException {
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalArgumentException("The type " + type.getName() + " is abstract!");
        }
        this.type = type;
        this.constructor = this.resolveConstructor();
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Class<?>[] getDependencies() {
        return this.constructor.getParameterTypes();
    }

    @Override
    @NotNull
    public Object provide(Object[] objects) throws Exception {
        return this.constructor.newInstance(objects);
    }

    private Constructor<?> resolveConstructor() throws ReflectiveOperationException {
        Constructor<?> bestConstructor = null;
        int bestPriority = -1;
        for (Constructor<?> constructor : this.type.getDeclaredConstructors()) {
            AccessUtil.setAccessible(constructor);
            int priority = -1;
            ContainerConstruct annotation = constructor.getAnnotation(ContainerConstruct.class);
            if (annotation != null) {
                priority = annotation.priority();
            }
            if (bestConstructor != null && bestPriority >= priority) continue;
            bestConstructor = constructor;
            bestPriority = priority;
        }
        if (bestConstructor == null) {
            bestConstructor = this.type.getDeclaredConstructor(new Class[0]);
        }
        return bestConstructor;
    }
}

