/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.container.object.singleton;

import info.cho.passwords.fairy.container.object.LifeCycle;
import info.cho.passwords.fairy.container.object.singleton.SingletonObjectRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SingletonObjectRegistryImpl
implements SingletonObjectRegistry {
    private final Map<Class<?>, Object> objectByType = new ConcurrentHashMap();
    private final Map<Class<?>, LifeCycle> lifeCycleByType = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSingleton(Class<?> type, Object instance) {
        Map<Class<?>, Object> map = this.objectByType;
        synchronized (map) {
            Object previous = this.objectByType.get(type);
            if (previous != null) {
                throw new IllegalStateException("Could not register object [" + instance + "] under type [" + type.getName() + "]: there is already object [" + previous + "] bound");
            }
            this.objectByType.put(type, instance);
        }
    }

    @Override
    public Object getSingleton(Class<?> type) {
        return this.objectByType.get(type);
    }

    @Override
    public boolean containsSingleton(Class<?> type) {
        return this.objectByType.containsKey(type);
    }

    @Override
    public void removeSingleton(Class<?> type) {
        this.objectByType.remove(type);
        this.lifeCycleByType.remove(type);
    }

    @Override
    public Set<Class<?>> getSingletonTypes() {
        return Collections.unmodifiableSet(this.objectByType.keySet());
    }

    @Override
    public LifeCycle getSingletonLifeCycle(Class<?> type) {
        return this.lifeCycleByType.getOrDefault(type, LifeCycle.NONE);
    }

    @Override
    public void setSingletonLifeCycle(Class<?> type, LifeCycle lifeCycle) {
        this.lifeCycleByType.put(type, lifeCycle);
    }
}

