/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.container.processor.annotation;

import info.cho.passwords.fairy.container.processor.annotation.LifeCycleElement;
import info.cho.passwords.fairy.util.ConditionUtils;
import info.cho.passwords.fairy.util.Utility;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class LifeCycleMetadata {
    private final Class<? extends Annotation>[] annotations;
    private final List<LifeCycleElement>[] processors;

    public LifeCycleMetadata(Class<?> instanceClass, Class<? extends Annotation>[] annotations) {
        this.annotations = annotations;
        this.processors = new List[4];
        for (int i = 0; i < this.processors.length; ++i) {
            this.processors[i] = new ArrayList<LifeCycleElement>();
        }
        for (Class<?> superClass : Utility.getSuperClasses(instanceClass)) {
            try {
                for (Method declaredMethod : superClass.getDeclaredMethods()) {
                    this.handleMethodInit(declaredMethod);
                }
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("An error occurs while scanning class " + superClass, throwable);
            }
        }
    }

    private void handleMethodInit(Method method) {
        for (int index = 0; index < this.annotations.length; ++index) {
            Class<? extends Annotation> annotation = this.annotations[index];
            this.handleAnnotationInit(method, index, annotation);
        }
    }

    private void handleAnnotationInit(Method method, int index, @Nullable Class<? extends Annotation> annotation) {
        if (annotation == null) {
            return;
        }
        if (!method.isAnnotationPresent(annotation)) {
            return;
        }
        ConditionUtils.is(method.getParameterCount() == 0, String.format("The method %s annotated with %s is not supposed to have parameters", method, annotation));
        LifeCycleElement processor = new LifeCycleElement(method);
        this.processors[index].add(processor);
    }

    public void invoke(int index, Object instance) {
        ConditionUtils.notNull(instance, "Instance of the container object hasn't yet been constructed.");
        this.processors[index].forEach(processor -> processor.invoke(instance));
    }
}

